/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.service;

import edu.harvard.i2b2.crc.datavo.i2b2message.SecurityType;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import net.shrine.adapter.dao.AdapterDAO;
import net.shrine.adapter.dao.UserAndMaster;
import net.shrine.broadcaster.dao.AuditDAO;
import net.shrine.broadcaster.dao.hibernate.AuditEntry;
import net.shrine.config.I2B2HiveConfig;
import net.shrine.config.I2B2HiveCredentials;
import net.shrine.config.ShrineConfig;
import net.shrine.protocol.AuthenticationInfo;
import net.shrine.protocol.BroadcastMessage;
import net.shrine.protocol.BroadcastMessage$;
import net.shrine.protocol.Credential;
import net.shrine.protocol.ResultOutputType;
import net.shrine.protocol.RunQueryRequest;
import net.shrine.serializers.crc.CRCRequestType;
import net.shrine.serializers.pm.PMHttpClient;
import net.shrine.service.HappyShrineRequestHandler;
import org.spin.node.DefaultQueries;
import org.spin.node.acknack.AckNack;
import org.spin.node.actions.discovery.DiscoveryCriteria;
import org.spin.node.actions.discovery.DiscoveryResult;
import org.spin.query.message.agent.SpinAgent;
import org.spin.query.message.headers.QueryInfo;
import org.spin.query.message.headers.Result;
import org.spin.query.message.headers.ResultSet;
import org.spin.tools.JAXBUtils;
import org.spin.tools.PKITool;
import org.spin.tools.config.ConfigTool;
import org.spin.tools.config.EndpointConfig;
import org.spin.tools.config.EndpointType;
import org.spin.tools.config.KeyStoreConfig;
import org.spin.tools.config.PeerGroupConfig;
import org.spin.tools.config.RoutingTableConfig;
import org.spin.tools.crypto.PKCryptor;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.XMLSignatureUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Utility$;
import scala.xml.XML$;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001%\u0011!\u0003S1qaf\u001c\u0006N]5oKN+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0004tQJLg.\u001a\u0006\u0002\u000f\u0005\u0019a.\u001a;\u0004\u0001M!\u0001A\u0003\n\u0017!\tY\u0001#D\u0001\r\u0015\tia\"\u0001\u0003mC:<'\"A\b\u0002\t)\fg/Y\u0005\u0003#1\u0011aa\u00142kK\u000e$\bCA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005eA\u0015\r\u001d9z'\"\u0014\u0018N\\3SKF,Xm\u001d;IC:$G.\u001a:\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0005=\u0005a1\u000f\u001b:j]\u0016\u001cuN\u001c4jOV\tq\u0004\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u000511m\u001c8gS\u001eL!\u0001J\u0011\u0003\u0019MC'/\u001b8f\u0007>tg-[4\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\tQb\u001d5sS:,7i\u001c8gS\u001e\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011B\u0015\u0002\u001f!Lg/Z\"sK\u0012,g\u000e^5bYN,\u0012A\u000b\t\u0003A-J!\u0001L\u0011\u0003'%\u0013$I\r%jm\u0016\u001c%/\u001a3f]RL\u0017\r\\:\t\u00119\u0002!\u0011!Q\u0001\n)\n\u0001\u0003[5wK\u000e\u0013X\rZ3oi&\fGn\u001d\u0011\t\u0011A\u0002!Q1A\u0005\nE\n\u0001\u0002]7DY&,g\u000e^\u000b\u0002eA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0003a6T!a\u000e\u0003\u0002\u0017M,'/[1mSj,'o]\u0005\u0003sQ\u0012A\u0002U'IiR\u00048\t\\5f]RD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006IAM\u0001\na6\u001cE.[3oi\u0002B\u0001\"\u0010\u0001\u0003\u0006\u0004%IAP\u0001\u000bgBLgn\u00117jK:$X#A \u0011\u0005\u0001[U\"A!\u000b\u0005\t\u001b\u0015!B1hK:$(B\u0001#F\u0003\u001diWm]:bO\u0016T!AR$\u0002\u000bE,XM]=\u000b\u0005!K\u0015\u0001B:qS:T\u0011AS\u0001\u0004_J<\u0017B\u0001'B\u0005%\u0019\u0006/\u001b8BO\u0016tG\u000f\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003@\u0003-\u0019\b/\u001b8DY&,g\u000e\u001e\u0011\t\u0011A\u0003!Q1A\u0005\nE\u000b\u0001\"Y;eSR$\u0015m\\\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0004I\u0006|'BA,\u0005\u0003-\u0011'o\\1eG\u0006\u001cH/\u001a:\n\u0005e#&\u0001C!vI&$H)Q(\t\u0011m\u0003!\u0011!Q\u0001\nI\u000b\u0011\"Y;eSR$\u0015m\u001c\u0011\t\u0011u\u0003!Q1A\u0005\ny\u000b!\"\u00193baR,'\u000fR1p+\u0005y\u0006C\u00011e\u001b\u0005\t'BA+c\u0015\t\u0019G!A\u0004bI\u0006\u0004H/\u001a:\n\u0005\u0015\f'AC!eCB$XM\u001d#B\u001f\"Aq\r\u0001B\u0001B\u0003%q,A\u0006bI\u0006\u0004H/\u001a:EC>\u0004\u0003\"B5\u0001\t\u0003Q\u0017A\u0002\u001fj]&$h\bF\u0004lY6tw\u000e]9\u0011\u0005M\u0001\u0001\"B\u000fi\u0001\u0004y\u0002\"\u0002\u0015i\u0001\u0004Q\u0003\"\u0002\u0019i\u0001\u0004\u0011\u0004\"B\u001fi\u0001\u0004y\u0004\"\u0002)i\u0001\u0004\u0011\u0006\"B/i\u0001\u0004y\u0006F\u00015t!\t!X0D\u0001v\u0015\t1x/\u0001\u0006b]:|G/\u0019;j_:T!\u0001_=\u0002\u000f\u0019\f7\r^8ss*\u0011!p_\u0001\u0006E\u0016\fgn\u001d\u0006\u0003y&\u000bqb\u001d9sS:<gM]1nK^|'o[\u0005\u0003}V\u0014\u0011\"Q;u_^L'/\u001a3\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0013\t\u0019!\u0001\bf]\u0012\u0004x.\u001b8u\u0007>tg-[4\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u001fi!!!\u0003\u000b\u0007\t\nYAC\u0002\u0002\u000e\u001d\u000bQ\u0001^8pYNLA!!\u0005\u0002\n\tqQI\u001c3q_&tGoQ8oM&<\u0007BCA\u000b\u0001!\u0005\t\u0015)\u0003\u0002\u0006\u0005yQM\u001c3q_&tGoQ8oM&<\u0007\u0005C\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u001d-,\u0017p\u001d;pe\u0016\u0014V\r]8siV\u0011\u0011Q\u0004\t\u0005\u0003?\t)CD\u0002\u0018\u0003CI1!a\t\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0005\r\t\u000f\u00055\u0002\u0001\"\u0001\u0002\u001c\u0005\u00112\u000f\u001b:j]\u0016\u001cuN\u001c4jOJ+\u0007o\u001c:u\u0011\u001d\t\t\u0004\u0001C\u0001\u00037\tQB]8vi&twMU3q_J$\bbBA\u001b\u0001\u0011\u0005\u00111D\u0001\u000bQ&4XMU3q_J$\bbBA\u001d\u0001\u0011%\u00111D\u0001\u0012S:4\u0018\r\\5e'BLgnQ8oM&<\u0007\u0002CA\u001f\u0001\u0011\u0005!!a\u0010\u0002%\u001d,g.\u001a:bi\u0016\u001c\u0006/\u001b8SKB|'\u000f\u001e\u000b\u0005\u0003;\t\t\u0005\u0003\u0005\u0002D\u0005m\u0002\u0019AA#\u00031\u0011x.\u001e;j]\u001e$\u0016M\u00197f!\u0011\t9!a\u0012\n\t\u0005%\u0013\u0011\u0002\u0002\u0013%>,H/\u001b8h)\u0006\u0014G.Z\"p]\u001aLw\rC\u0004\u0002N\u0001!\t!a\u0007\u0002\u0015M\u0004\u0018N\u001c*fa>\u0014H\u000fC\u0004\u0002R\u0001!I!a\u0015\u0002%9,wOU;o#V,'/\u001f*fcV,7\u000f^\u000b\u0003\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037\"\u0011\u0001\u00039s_R|7m\u001c7\n\t\u0005}\u0013\u0011\f\u0002\u0010%Vt\u0017+^3ssJ+\u0017/^3ti\"9\u00111\r\u0001\u0005\u0002\u0005m\u0011!D1eCB$XM\u001d*fa>\u0014H\u000fC\u0004\u0002h\u0001!\t!a\u0007\u0002\u0017\u0005,H-\u001b;SKB|'\u000f\u001e\u0015\t\u0003K\nY'!\u001f\u0002|A!\u0011QNA;\u001b\t\tyGC\u0002w\u0003cR1!a\u001d|\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005]\u0014q\u000e\u0002\u000e)J\fgn]1di&|g.\u00197\u0002\u0011I,\u0017\rZ(oYfL\u0012!\u0001\u0005\b\u0003\u007f\u0002A\u0011AA\u000e\u0003-\tX/\u001a:z%\u0016\u0004xN\u001d;)\u0011\u0005u\u00141NA=\u0003wBq!!\"\u0001\t\u0003\tY\"A\u0002bY2D\u0003\"a!\u0002l\u0005e\u00141\u0010\u0015\u0004\u0001\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E50\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!&\u0002\u0010\n91+\u001a:wS\u000e,\u0007")
public class HappyShrineService
implements HappyShrineRequestHandler,
ScalaObject {
    private final ShrineConfig net$shrine$service$HappyShrineService$$shrineConfig;
    private final I2B2HiveCredentials hiveCredentials;
    private final PMHttpClient pmClient;
    private final SpinAgent spinClient;
    private final AuditDAO auditDao;
    private final AdapterDAO adapterDao;
    private EndpointConfig endpointConfig;
    private volatile int bitmap$priv$0;

    public final ShrineConfig net$shrine$service$HappyShrineService$$shrineConfig() {
        return this.net$shrine$service$HappyShrineService$$shrineConfig;
    }

    private I2B2HiveCredentials hiveCredentials() {
        return this.hiveCredentials;
    }

    private PMHttpClient pmClient() {
        return this.pmClient;
    }

    private SpinAgent spinClient() {
        return this.spinClient;
    }

    private AuditDAO auditDao() {
        return this.auditDao;
    }

    private AdapterDAO adapterDao() {
        return this.adapterDao;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EndpointConfig endpointConfig() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.endpointConfig;
        HappyShrineService happyShrineService = this;
        synchronized (happyShrineService) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.endpointConfig = new EndpointConfig(EndpointType.SOAP, this.net$shrine$service$HappyShrineService$$shrineConfig().getAggregatorEndpoint());
                this.bitmap$priv$0 |= 1;
            }
            return this.endpointConfig;
        }
    }

    public String keystoreReport() {
        KeyStoreConfig keystoreConfig = ConfigTool.loadKeyStoreConfig();
        PKITool pki = PKITool.getInstance();
        CertID certId = pki.getMyX509().getCertID();
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)keystoreConfig.getFile().toURI());
        $buf.$amp$plus((Object)new Elem(null, "configFile", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$4 = Predef$.MODULE$.$scope();
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)certId.getName());
        $buf3.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n          "));
        TopScope$ topScope$5 = Predef$.MODULE$.$scope();
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)certId.getSerial());
        $buf3.$amp$plus((Object)new Elem(null, "serial", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$5, (Seq)$buf5));
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "certId", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$6 = Predef$.MODULE$.$scope();
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus(JavaConversions$.MODULE$.asScalaSet(pki.getImportedCertsCopy()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final Elem apply(CertData cert) {
                void var2_2;
                void var3_3;
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)cert.getCertID().getName());
                $buf.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var3_3));
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)cert.getCertID().getSerial().toString());
                $buf.$amp$plus((Object)new Elem(null, "serial", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "cert", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
            }
        }, Set$.MODULE$.canBuildFrom()));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "importedCerts", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$6, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        return Utility$.MODULE$.trim((Node)new Elem(null, "keystoreReport", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf)).toString();
    }

    public String shrineConfigReport() {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ShrineConfig.class}).createMarshaller();
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        StringWriter sWriter = new StringWriter();
        marshaller.marshal((Object)this.net$shrine$service$HappyShrineService$$shrineConfig(), (Writer)sWriter);
        return sWriter.toString();
    }

    public String routingReport() {
        Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{RoutingTableConfig.class}).createMarshaller();
        marshaller.setProperty("com.sun.xml.bind.xmlDeclaration", (Object)BoxesRunTime.boxToBoolean((boolean)false));
        StringWriter sWriter = new StringWriter();
        marshaller.marshal((Object)ConfigTool.loadRoutingTableConfig(), (Writer)sWriter);
        return sWriter.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String hiveReport() {
        void var3_3;
        SecurityType securityType = new SecurityType(this.hiveCredentials().getDomain(), this.hiveCredentials().getUsername(), this.hiveCredentials().getPassword());
        I2B2HiveConfig hiveConfig = this.pmClient().getServices(securityType);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)hiveConfig.getCRCURL());
        $buf.$amp$plus((Object)new Elem(null, "crcUrl", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)hiveConfig.getONTURL());
        $buf.$amp$plus((Object)new Elem(null, "ontUrl", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        return Utility$.MODULE$.trim((Node)new Elem(null, "hiveConfig", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var3_3)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private String invalidSpinConfig() {
        void var1_1;
        void var3_3;
        void var2_2;
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("false"));
        $buf.$amp$plus((Object)new Elem(null, "properlyConnected", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var2_2));
        $buf.$amp$plus((Object)new Text("\n      "));
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("peer group to query is not defined in routing table"));
        $buf.$amp$plus((Object)new Elem(null, "error", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return Utility$.MODULE$.trim((Node)new Elem(null, "spin", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_1)).toString();
    }

    public String generateSpinReport(RoutingTableConfig routingTable) {
        Option peerGroupOption = JavaConversions$.MODULE$.asScalaBuffer(routingTable.getPeerGroups()).find((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final HappyShrineService $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(PeerGroupConfig x) {
                return x.getGroupName().equals(this.$outer.net$shrine$service$HappyShrineService$$shrineConfig().getBroadcasterPeerGroupToQuery());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (peerGroupOption.isDefined()) {
            Identity identity = XMLSignatureUtil.getDefaultInstance().sign(new Identity("happy", "happy"));
            QueryInfo queryInfo = new QueryInfo(this.net$shrine$service$HappyShrineService$$shrineConfig().getBroadcasterPeerGroupToQuery(), identity, DefaultQueries.Discovery.queryType(), this.endpointConfig());
            AckNack ackNack = this.spinClient().send(queryInfo, (Object)new DiscoveryCriteria());
            ResultSet results = this.spinClient().receive(ackNack.getQueryID(), identity);
            int expectedCount = ((PeerGroupConfig)peerGroupOption.get()).getChildren().size() + 1;
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            TopScope$ topScope$2 = Predef$.MODULE$.$scope();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)BoxesRunTime.boxToBoolean((expectedCount == results.size() ? 1 : 0) != 0));
            $buf.$amp$plus((Object)new Elem(null, "properlyConnected", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n        "));
            TopScope$ topScope$3 = Predef$.MODULE$.$scope();
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)BoxesRunTime.boxToInteger((int)expectedCount));
            $buf.$amp$plus((Object)new Elem(null, "expectedNodeCount", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
            $buf.$amp$plus((Object)new Text("\n        "));
            TopScope$ topScope$4 = Predef$.MODULE$.$scope();
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)BoxesRunTime.boxToInteger((int)results.size()));
            $buf.$amp$plus((Object)new Elem(null, "actualNodeCount", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus(JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)results).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Elem apply(Result spinResult) {
                    String xmlString = new PKCryptor().decrypt(spinResult.getPayload());
                    DiscoveryResult discoveryResult = (DiscoveryResult)JAXBUtils.unmarshal((String)xmlString, DiscoveryResult.class);
                    TopScope$ topScope$ = Predef$.MODULE$.$scope();
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)discoveryResult.getNodeConfig().getNodeName());
                    $buf.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
                    $buf.$amp$plus((Object)new Text("\n              "));
                    TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)discoveryResult.getNodeURL());
                    $buf.$amp$plus((Object)new Elem(null, "url", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    return new Elem(null, "node", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
                }
            }, Iterable$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n      "));
            return Utility$.MODULE$.trim((Node)new Elem(null, "spin", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf)).toString();
        }
        return this.invalidSpinConfig();
    }

    public String spinReport() {
        RoutingTableConfig routingTable = ConfigTool.loadRoutingTableConfig();
        return this.generateSpinReport(routingTable);
    }

    private RunQueryRequest newRunQueryRequest() {
        TopScope$ $tmpscope = Predef$.MODULE$.$scope();
        $tmpscope = new NamespaceBinding("xsi", "http://www.w3.org/2001/XMLSchema-instance", (NamespaceBinding)$tmpscope);
        TopScope$ $scope = $tmpscope = new NamespaceBinding("ns4", "http://www.i2b2.org/xsd/cell/crc/psm/1.1/", (NamespaceBinding)$tmpscope);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("PDD"));
        $buf.$amp$plus((Object)new Elem(null, "query_name", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("0"));
        $buf.$amp$plus((Object)new Elem(null, "specificity_scale", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("1"));
        $buf.$amp$plus((Object)new Elem(null, "use_shrine", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("1"));
        $buf5.$amp$plus((Object)new Elem(null, "panel_number", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("0"));
        $buf5.$amp$plus((Object)new Elem(null, "invert", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf7));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("1"));
        $buf5.$amp$plus((Object)new Elem(null, "total_item_occurrences", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf8));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("3"));
        $buf9.$amp$plus((Object)new Elem(null, "hlevel", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf10));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("PDD"));
        $buf9.$amp$plus((Object)new Elem(null, "item_name", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf11));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)this.net$shrine$service$HappyShrineService$$shrineConfig().getAdapterStatusQuery());
        $buf9.$amp$plus((Object)new Elem(null, "item_key", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf12));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)this.net$shrine$service$HappyShrineService$$shrineConfig().getAdapterStatusQuery());
        $buf9.$amp$plus((Object)new Elem(null, "tooltip", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf13));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)new Text("ENC"));
        $buf9.$amp$plus((Object)new Elem(null, "class", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf14));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)new Elem(null, "constrain_by_date", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf15));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("FA"));
        $buf9.$amp$plus((Object)new Elem(null, "item_icon", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf16));
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("false"));
        $buf9.$amp$plus((Object)new Elem(null, "item_is_synonym", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf17));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf5.$amp$plus((Object)new Elem(null, "item", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf9));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "panel", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        String queryDefinitionXml = Utility$.MODULE$.trim((Node)new Elem("ns4", "query_definition", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, (Seq)$buf)).toString();
        return new RunQueryRequest("happyProject", 180000L, new AuthenticationInfo("happyDomain", "happy", new Credential("", false)), "", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ResultOutputType[]{ResultOutputType.PATIENT_COUNT_XML})), queryDefinitionXml);
    }

    /*
     * WARNING - void declaration
     */
    public String adapterReport() {
        String string;
        if (this.net$shrine$service$HappyShrineService$$shrineConfig().isAdapter()) {
            Identity identity = XMLSignatureUtil.getDefaultInstance().sign(new Identity("happy", "happy"));
            QueryInfo queryInfo = new QueryInfo("LOCAL", identity, CRCRequestType.QueryDefinitionRequestType.name(), this.endpointConfig());
            BroadcastMessage message = BroadcastMessage$.MODULE$.apply(this.newRunQueryRequest());
            AckNack ackNack = this.spinClient().send(queryInfo, (Object)message, BroadcastMessage$.MODULE$.serializer());
            ResultSet resultSet = this.spinClient().receive(ackNack.getQueryID(), identity);
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            TopScope$ topScope$2 = Predef$.MODULE$.$scope();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("true"));
            $buf.$amp$plus((Object)new Elem(null, "isAdapter", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)resultSet).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                public final Elem apply(Result result) {
                    void var2_2;
                    void var3_3;
                    TopScope$ topScope$ = Predef$.MODULE$.$scope();
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n                "));
                    TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)result.getDescription());
                    $buf.$amp$plus((Object)new Elem(null, "description", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var3_3));
                    $buf.$amp$plus((Object)new Text("\n                "));
                    TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n                  "));
                    String decryptedPayload = new PKCryptor().decrypt(result.getPayload());
                    $buf3.$amp$plus((Object)XML$.MODULE$.loadString(decryptedPayload));
                    $buf3.$amp$plus((Object)new Text("\n                "));
                    $buf.$amp$plus((Object)new Elem(null, "payload", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                    $buf.$amp$plus((Object)new Text("\n              "));
                    return new Elem(null, "result", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
                }
            }, Iterable$.MODULE$.canBuildFrom()));
            $buf.$amp$plus((Object)new Text("\n        "));
            string = Utility$.MODULE$.trim((Node)new Elem(null, "adapter", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf)).toString();
        } else {
            void var1_8;
            void var2_9;
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            TopScope$ topScope$3 = Predef$.MODULE$.$scope();
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("false"));
            $buf.$amp$plus((Object)new Elem(null, "isAdapter", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)var2_9));
            $buf.$amp$plus((Object)new Text("\n        "));
            string = Utility$.MODULE$.trim((Node)new Elem(null, "adapter", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var1_8)).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    public String auditReport() {
        void var2_2;
        List recentEntries = this.auditDao().findRecentEntries(10);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(JavaConversions$.MODULE$.asScalaBuffer(recentEntries).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final Elem apply(AuditEntry entry) {
                void var2_2;
                void var3_3;
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)BoxesRunTime.boxToLong((long)entry.getAuditEntryId()));
                $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var3_3));
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)entry.getTime());
                $buf.$amp$plus((Object)new Elem(null, "time", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$4 = Predef$.MODULE$.$scope();
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)entry.getUsername());
                $buf.$amp$plus((Object)new Elem(null, "username", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "entry", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        $buf.$amp$plus((Object)new Text("\n      "));
        return Utility$.MODULE$.trim((Node)new Elem(null, "recentAuditEntries", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=true)
    public String queryReport() {
        void var2_2;
        List recentQueries = this.adapterDao().findRecentQueries(10);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus(JavaConversions$.MODULE$.asScalaBuffer(recentQueries).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             */
            public final Elem apply(UserAndMaster query) {
                void var2_2;
                void var3_3;
                TopScope$ topScope$ = Predef$.MODULE$.$scope();
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$2 = Predef$.MODULE$.$scope();
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)query.getNetworkMasterID());
                $buf.$amp$plus((Object)new Elem(null, "id", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)var3_3));
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$3 = Predef$.MODULE$.$scope();
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)query.getMasterCreateDate());
                $buf.$amp$plus((Object)new Elem(null, "date", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3));
                $buf.$amp$plus((Object)new Text("\n              "));
                TopScope$ topScope$4 = Predef$.MODULE$.$scope();
                NodeBuffer $buf4 = new NodeBuffer();
                $buf4.$amp$plus((Object)query.getMasterName());
                $buf.$amp$plus((Object)new Elem(null, "name", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$4, (Seq)$buf4));
                $buf.$amp$plus((Object)new Text("\n            "));
                return new Elem(null, "query", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2);
            }
        }, Buffer$.MODULE$.canBuildFrom()));
        $buf.$amp$plus((Object)new Text("\n      "));
        return Utility$.MODULE$.trim((Node)new Elem(null, "recentQueries", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)var2_2)).toString();
    }

    @Transactional(readOnly=true)
    public String all() {
        return "<all>" + this.keystoreReport() + this.shrineConfigReport() + this.routingReport() + this.hiveReport() + this.spinReport() + this.adapterReport() + this.auditReport() + this.queryReport() + "</all>";
    }

    @Autowired
    public HappyShrineService(ShrineConfig shrineConfig, I2B2HiveCredentials hiveCredentials, PMHttpClient pmClient, SpinAgent spinClient, AuditDAO auditDao, AdapterDAO adapterDao) {
        this.net$shrine$service$HappyShrineService$$shrineConfig = shrineConfig;
        this.hiveCredentials = hiveCredentials;
        this.pmClient = pmClient;
        this.spinClient = spinClient;
        this.auditDao = auditDao;
        this.adapterDao = adapterDao;
    }
}

