/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import java.time.Instant;
import java.time.ZonedDateTime;
import org.http4s.HttpDate;
import org.http4s.ParseFailure;
import org.http4s.ParseResult$;
import org.http4s.parser.AdditionalRules$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class HttpDate$ {
    public static final HttpDate$ MODULE$;
    private final long MinEpochSecond;
    private final long MaxEpochSecond;
    private final HttpDate MinValue;
    private final HttpDate MaxValue;
    private final HttpDate Epoch;

    static {
        new HttpDate$();
    }

    private long MinEpochSecond() {
        return this.MinEpochSecond;
    }

    private long MaxEpochSecond() {
        return this.MaxEpochSecond;
    }

    public HttpDate MinValue() {
        return this.MinValue;
    }

    public HttpDate MaxValue() {
        return this.MaxValue;
    }

    public HttpDate now() {
        return this.unsafeFromInstant(Instant.now());
    }

    public HttpDate Epoch() {
        return this.Epoch;
    }

    public Either<ParseFailure, HttpDate> fromString(String s2) {
        return AdditionalRules$.MODULE$.httpDate(s2);
    }

    public HttpDate unsafeFromString(String s2) {
        return (HttpDate)this.fromString(s2).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(ParseFailure x$1) {
                throw x$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HttpDate apply(HttpDate x) {
                return (HttpDate)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Either<ParseFailure, HttpDate> fromEpochSecond(long epochSecond) {
        return epochSecond < this.MinEpochSecond() || epochSecond > this.MaxEpochSecond() ? ParseResult$.MODULE$.fail("Invalid HTTP date", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " out of range for HTTP date. Must be between ", " and ", ", inclusive"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)epochSecond), BoxesRunTime.boxToLong((long)this.MinEpochSecond()), BoxesRunTime.boxToLong((long)this.MaxEpochSecond())}))) : ParseResult$.MODULE$.success(new HttpDate(epochSecond));
    }

    public HttpDate unsafeFromEpochSecond(long epochSecond) {
        return (HttpDate)this.fromEpochSecond(epochSecond).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(ParseFailure x$2) {
                throw x$2;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HttpDate apply(HttpDate x) {
                return (HttpDate)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public Either<ParseFailure, HttpDate> fromInstant(Instant instant) {
        return this.fromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public HttpDate unsafeFromInstant(Instant instant) {
        return this.unsafeFromEpochSecond(instant.toEpochMilli() / 1000L);
    }

    public Either<ParseFailure, HttpDate> fromZonedDateTime(ZonedDateTime dateTime) {
        return this.fromInstant(dateTime.toInstant());
    }

    public HttpDate unsafeFromZonedDateTime(ZonedDateTime dateTime) {
        return this.unsafeFromInstant(dateTime.toInstant());
    }

    private HttpDate$() {
        MODULE$ = this;
        this.MinEpochSecond = -2208988800L;
        this.MaxEpochSecond = 253402300799L;
        this.MinValue = this.unsafeFromEpochSecond(this.MinEpochSecond());
        this.MaxValue = this.unsafeFromEpochSecond(this.MaxEpochSecond());
        this.Epoch = this.unsafeFromEpochSecond(0L);
    }
}

