/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Applicative;
import cats.Foldable;
import cats.Functor;
import cats.MonadError;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.NonEmptyList$;
import cats.implicits$;
import cats.syntax.FoldableOps$;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.text$;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Vault;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.Entity;
import org.http4s.EntityDecoder;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.Message;
import org.http4s.Message$;
import org.http4s.Message$Keys$;
import org.http4s.ParseFailure;
import org.http4s.TransferCoding$;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.Transfer$minusEncoding;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.util.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class Message$class {
    public static HttpVersion change$default$1(Message $this) {
        return $this.httpVersion();
    }

    public static FreeC change$default$2(Message $this) {
        return $this.body();
    }

    public static List change$default$3(Message $this) {
        return $this.headers();
    }

    public static Vault change$default$4(Message $this) {
        return $this.attributes();
    }

    public static Message withHttpVersion(Message $this, HttpVersion httpVersion) {
        return $this.change(httpVersion, $this.change$default$2(), (List<Header>)$this.change$default$3(), $this.change$default$4());
    }

    public static Message withHeaders(Message $this, List headers) {
        List x$27 = headers;
        HttpVersion x$28 = $this.change$default$1();
        FreeC<?, BoxedUnit> x$29 = $this.change$default$2();
        Vault x$30 = $this.change$default$4();
        return $this.change(x$28, x$29, (List<Header>)x$27, x$30);
    }

    public static Message withHeaders(Message $this, Seq headers) {
        return $this.withHeaders(Headers$.MODULE$.apply((List<Header>)headers.toList()));
    }

    public static Message withAttributes(Message $this, Vault attributes) {
        Vault x$31 = attributes;
        HttpVersion x$32 = $this.change$default$1();
        FreeC<?, BoxedUnit> x$33 = $this.change$default$2();
        List x$34 = $this.change$default$3();
        return $this.change(x$32, x$33, (List<Header>)x$34, x$31);
    }

    public static Object withBody(Message $this, Object b, Applicative F, EntityEncoder w) {
        return F.pure((Object)$this.withEntity(b, w));
    }

    public static Message withEntity(Message $this, Object b, EntityEncoder w) {
        Option<Object> option;
        block4: {
            List<Header> list;
            Entity entity;
            block3: {
                block2: {
                    entity = w.toEntity(b);
                    option = entity.length();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    long l = BoxesRunTime.unboxToLong((Object)some.x());
                    list = ((Headers)Content$minusLength$.MODULE$.fromLong(l).fold((Function1)new Serializable($this, l, w){
                        public static final long serialVersionUID = 0L;
                        private final long l$1;
                        private final EntityEncoder w$1;

                        public final List apply(ParseFailure x$1) {
                            if (Message$.MODULE$.logger().isWarnEnabled()) {
                                Message$.MODULE$.logger().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempt to provide a negative content length of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.l$1)})));
                            }
                            return this.w$1.headers();
                        }
                        {
                            void var4_3;
                            this.l$1 = l$1;
                            this.w$1 = var4_3;
                        }
                    }, (Function1)new Serializable($this, w){
                        public static final long serialVersionUID = 0L;
                        private final EntityEncoder w$1;

                        public final List apply(Content$minusLength cl) {
                            Content$minusLength content$minusLength = cl;
                            return Headers$.MODULE$.apply((List<Header>)Headers$.MODULE$.toList$extension((List<Header>)this.w$1.headers()).$colon$colon((Object)content$minusLength));
                        }
                        {
                            this.w$1 = w$1;
                        }
                    })).org$http4s$Headers$$headers();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                list = w.headers();
            }
            List<Header> hs = list;
            FreeC<?, BoxedUnit> x$35 = entity.body();
            List x$36 = Headers$.MODULE$.$plus$plus$extension($this.headers(), (List)hs);
            HttpVersion x$37 = $this.change$default$1();
            Vault x$38 = $this.change$default$4();
            return $this.change(x$37, x$35, (List<Header>)x$36, x$38);
        }
        throw new MatchError(option);
    }

    public static Message withBodyStream(Message $this, FreeC body) {
        FreeC x$39 = body;
        HttpVersion x$40 = $this.change$default$1();
        List x$41 = $this.change$default$3();
        Vault x$42 = $this.change$default$4();
        return $this.change(x$40, x$39, (List<Header>)x$41, x$42);
    }

    public static Message withEmptyBody(Message $this) {
        return $this.withBodyStream(org.http4s.package$.MODULE$.EmptyBody()).transformHeaders((Function1<List<Header>, List<Header>>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final List apply(List x$3) {
                return Headers$.MODULE$.removePayloadHeaders$extension(x$3);
            }
        });
    }

    public static FreeC bodyAsText(Message $this, Charset defaultCharset) {
        Charset charset2 = (Charset)$this.charset().getOrElse((Function0)new Serializable($this, defaultCharset){
            public static final long serialVersionUID = 0L;
            private final Charset defaultCharset$1;

            public final Charset apply() {
                return this.defaultCharset$1;
            }
            {
                this.defaultCharset$1 = defaultCharset$1;
            }
        });
        Charset charset3 = Charset$.MODULE$.UTF$minus8();
        Charset charset4 = charset2;
        FreeC freeC = !(charset3 != null ? !((Object)charset3).equals(charset4) : charset4 != null) ? Stream$.MODULE$.through$extension($this.body(), text$.MODULE$.utf8Decode()) : Stream$.MODULE$.through$extension($this.body(), package$.MODULE$.decode(charset2));
        return freeC;
    }

    public static Charset bodyAsText$default$1(Message $this) {
        return org.http4s.package$.MODULE$.DefaultCharset();
    }

    public static Message transformHeaders(Message $this, Function1 f2) {
        List<Header> x$43 = ((Headers)f2.apply((Object)new Headers((List<Header>)$this.headers()))).org$http4s$Headers$$headers();
        HttpVersion x$44 = $this.change$default$1();
        FreeC<?, BoxedUnit> x$45 = $this.change$default$2();
        Vault x$46 = $this.change$default$4();
        return $this.change(x$44, x$45, x$43, x$46);
    }

    public static Message filterHeaders(Message $this, Function1 f2) {
        return $this.transformHeaders((Function1<List<Header>, List<Header>>)new Serializable($this, f2){
            public static final long serialVersionUID = 0L;
            private final Function1 f$1;

            public final List apply(List x$4) {
                return Headers$.MODULE$.filter$extension((List<Header>)x$4, (Function1<Header, Object>)this.f$1);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static Message removeHeader(Message $this, HeaderKey key) {
        return $this.filterHeaders((Function1<Header, Object>)new Serializable($this, key){
            public static final long serialVersionUID = 0L;
            private final HeaderKey key$1;

            public final boolean apply(Header x$5) {
                return x$5.isNot(this.key$1);
            }
            {
                this.key$1 = key$1;
            }
        });
    }

    public static Message putHeaders(Message $this, Seq headers) {
        return $this.transformHeaders((Function1<List<Header>, List<Header>>)new Serializable($this, headers){
            public static final long serialVersionUID = 0L;
            private final Seq headers$2;

            public final List apply(List x$6) {
                return Headers$.MODULE$.put$extension((List<Header>)x$6, (Seq<Header>)this.headers$2);
            }
            {
                this.headers$2 = headers$2;
            }
        });
    }

    public static Message replaceAllHeaders(Message $this, List headers) {
        return $this.withHeaders((List<Header>)headers);
    }

    public static Message replaceAllHeaders(Message $this, Seq headers) {
        return $this.withHeaders((Seq<Header>)headers);
    }

    public static Message withTrailerHeaders(Message $this, Object trailerHeaders2) {
        return $this.withAttribute(Message$Keys$.MODULE$.TrailerHeaders(), trailerHeaders2);
    }

    public static Message withoutTrailerHeaders(Message $this) {
        return $this.withoutAttribute(Message$Keys$.MODULE$.TrailerHeaders());
    }

    public static Object trailerHeaders(Message $this, Applicative F) {
        return $this.attributes().lookup(Message$Keys$.MODULE$.TrailerHeaders()).getOrElse((Function0)new Serializable($this, F){
            public static final long serialVersionUID = 0L;
            private final Applicative F$2;

            public final F apply() {
                return (F)this.F$2.pure((Object)new Headers((List<Header>)Headers$.MODULE$.empty()));
            }
            {
                this.F$2 = F$2;
            }
        });
    }

    public static Message withType(Message $this, MediaType t, Functor F) {
        return $this.withContentType(Content$minusType$.MODULE$.apply(t));
    }

    public static Message withContentType(Message $this, Content$minusType contentType) {
        return $this.putHeaders((Seq<Header>)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{contentType}));
    }

    public static Message withoutContentType(Message $this) {
        return $this.filterHeaders((Function1<Header, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Header x$7) {
                return x$7.isNot(Content$minusType$.MODULE$);
            }
        });
    }

    public static Message withContentTypeOption(Message $this, Option contentTypeO) {
        return (Message)contentTypeO.fold((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Message $outer;

            public final Message apply() {
                return this.$outer.withoutContentType();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Message $outer;

            public final Message apply(Content$minusType contentType) {
                return this.$outer.withContentType(contentType);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Option contentType(Message $this) {
        return Headers$.MODULE$.get$extension0((List<Header>)$this.headers(), Content$minusType$.MODULE$);
    }

    public static Option contentLength(Message $this) {
        return Headers$.MODULE$.get$extension0((List<Header>)$this.headers(), Content$minusLength$.MODULE$).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(Content$minusLength x$8) {
                return x$8.length();
            }
        });
    }

    public static Option charset(Message $this) {
        return $this.contentType().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Charset> apply(Content$minusType x$9) {
                return x$9.charset();
            }
        });
    }

    public static boolean isChunked(Message $this) {
        return Headers$.MODULE$.get$extension0((List<Header>)$this.headers(), Transfer$minusEncoding$.MODULE$).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Transfer$minusEncoding x$10) {
                return FoldableOps$.MODULE$.contains_$extension(implicits$.MODULE$.catsSyntaxFoldOps(x$10.values(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()), (Object)TransferCoding$.MODULE$.chunked(), TransferCoding$.MODULE$.http4sOrderForTransferCoding(), (Foldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList());
            }
        });
    }

    public static Message withAttribute(Message $this, Key key, Object value2) {
        Vault x$47 = $this.attributes().insert(key, value2);
        HttpVersion x$48 = $this.change$default$1();
        FreeC<?, BoxedUnit> x$49 = $this.change$default$2();
        List x$50 = $this.change$default$3();
        return $this.change(x$48, x$49, (List<Header>)x$50, x$47);
    }

    public static Message withoutAttribute(Message $this, Key key) {
        Vault x$51 = $this.attributes().delete(key);
        HttpVersion x$52 = $this.change$default$1();
        FreeC<?, BoxedUnit> x$53 = $this.change$default$2();
        List x$54 = $this.change$default$3();
        return $this.change(x$52, x$53, (List<Header>)x$54, x$51);
    }

    public static EitherT attemptAs(Message $this, EntityDecoder decoder2) {
        return decoder2.decode($this, false);
    }

    public static Object as(Message $this, MonadError F, EntityDecoder decoder2) {
        return ((EitherT)implicits$.MODULE$.toBifunctorOps($this.attemptAs(decoder2), EitherT$.MODULE$.catsDataBifunctorForEitherT((Functor)F)).leftWiden()).rethrowT(F);
    }

    public static void $init$(Message $this) {
    }
}

