/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.nio.ByteBuffer;
import org.http4s.websocket.FrameTranscoder$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.package$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

@ScalaSignature(bytes="\u0006\u0001e<a!\u0001\u0002\t\u0002\u0011A\u0011a\u0004$sC6,GK]1og\u000e|G-\u001a:\u000b\u0005\r!\u0011!C<fEN|7m[3u\u0015\t)a!\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002\u000f\u0005\u0019qN]4\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0003\r\u0005=1%/Y7f)J\fgn]2pI\u0016\u00148C\u0001\u0006\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\")AC\u0003C\u0001-\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\t\r\u0011A\"BA\r\u0003\u001dQ\u0013\u0018M\\:d_\u0012,WI\u001d:peN\u0011qC\u0007\t\u00037\rr!\u0001H\u0011\u000f\u0005u\u0001S\"\u0001\u0010\u000b\u0005})\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\t\u0011s\"A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011*#!C#yG\u0016\u0004H/[8o\u0015\t\u0011s\u0002\u0003\u0005(/\t\u0015\r\u0011\"\u0001)\u0003\u001diWm]:bO\u0016,\u0012!\u000b\t\u0003U5r!AD\u0016\n\u00051z\u0011A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\b\t\u0011E:\"\u0011!Q\u0001\n%\n\u0001\"\\3tg\u0006<W\r\t\u0005\u0006)]!\ta\r\u000b\u0003iY\u0002\"!N\f\u000e\u0003)AQa\n\u001aA\u0002%BQ\u0001\u000f\u0006\u0005\ne\nA\u0002Z3d_\u0012,')\u001b8bef$2A\u000f!K!\rq1(P\u0005\u0003y=\u0011Q!\u0011:sCf\u0004\"A\u0004 \n\u0005}z!\u0001\u0002\"zi\u0016DQ!Q\u001cA\u0002\t\u000b!!\u001b8\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015a\u00018j_*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u0017^\u0002\rAO\u0001\u0005[\u0006\u001c8\u000eC\u0003N\u0015\u0011%a*\u0001\u0007mK:<G\u000f[(gMN,G\u000f\u0006\u0002P%B\u0011a\u0002U\u0005\u0003#>\u00111!\u00138u\u0011\u0015\tE\n1\u0001C\u0011\u0015!&\u0002\"\u0003V\u0003\u001d9W\r^'bg.$\"A\u000f,\t\u000b\u0005\u001b\u0006\u0019\u0001\"\t\u000baSA\u0011B-\u0002\u0015\t|G-\u001f'f]\u001e$\b\u000e\u0006\u0002P5\")\u0011i\u0016a\u0001\u0005\")AL\u0003C\u0005;\u0006aq-\u001a;Ng\u001edUM\\4uQR\u0011qJ\u0018\u0005\u0006\u0003n\u0003\rA\u0011\u0004\u0005\u0017\t\u0001\u0001m\u0005\u0002`\u001b!A!m\u0018BC\u0002\u0013\u00051-\u0001\u0005jg\u000ec\u0017.\u001a8u+\u0005!\u0007C\u0001\bf\u0013\t1wBA\u0004C_>dW-\u00198\t\u0011!|&\u0011!Q\u0001\n\u0011\f\u0011\"[:DY&,g\u000e\u001e\u0011\t\u000bQyF\u0011\u00016\u0015\u0005-d\u0007CA\u0005`\u0011\u0015\u0011\u0017\u000e1\u0001e\u0011\u0015qw\f\"\u0001p\u000351'/Y7f)>\u0014UO\u001a4feR\u0011\u0001/\u001d\t\u0004\u001dm\u0012\u0005\"B!n\u0001\u0004\u0011\bCA\u0005t\u0013\t!(A\u0001\bXK\n\u001cvnY6fi\u001a\u0013\u0018-\\3\t\u000bY|F\u0011A<\u0002\u001b\t,hMZ3s)>4%/Y7f)\t\u0011\b\u0010C\u0003Bk\u0002\u0007!\t")
public class FrameTranscoder {
    private final boolean isClient;

    public boolean isClient() {
        return this.isClient;
    }

    public ByteBuffer[] frameToBuffer(WebSocketFrame in) {
        ByteBuffer[] byteBufferArray;
        int size = 2;
        if (this.isClient()) {
            size += 4;
        }
        if (in.length() >= 126) {
            size = in.length() <= 65535 ? (size += 2) : (size += 8);
        }
        ByteBuffer buff = ByteBuffer.allocate(this.isClient() ? size + in.length() : size);
        int opcode = in.opcode();
        if (in.length() > 125 && (opcode == package$.MODULE$.PING() || opcode == package$.MODULE$.PONG() || opcode == package$.MODULE$.CLOSE())) {
            throw new TranscodeError(new StringBuilder().append((Object)"Invalid PING frame: frame too long: ").append((Object)BoxesRunTime.boxToInteger((int)in.length())).toString());
        }
        int b1 = in.last() ? opcode | package$.MODULE$.FINISHED() : opcode;
        buff.put(Predef$.MODULE$.int2Integer(b1).byteValue());
        int b2 = 0;
        if (this.isClient()) {
            b2 = package$.MODULE$.MASK();
        }
        b2 = in.length() < 126 ? (b2 |= in.length()) : (in.length() <= 65535 ? (b2 |= 0x7E) : (b2 |= 0x7F));
        buff.put(Predef$.MODULE$.int2Integer(b2).byteValue());
        Object object = in.length() > 125 && in.length() <= 65535 ? buff.put((byte)(in.length() >>> 8 & 0xFF)).put((byte)(in.length() & 0xFF)) : (in.length() > 65535 ? buff.putLong(in.length()) : BoxedUnit.UNIT);
        if (this.isClient() && in.length() > 0) {
            int mask = (int)(Math.random() * (double)Integer.MAX_VALUE);
            byte[] maskBits = new byte[]{(byte)(mask >>> 24 & 0xFF), (byte)(mask >>> 16 & 0xFF), (byte)(mask >>> 8 & 0xFF), (byte)(mask >>> 0 & 0xFF)};
            buff.put(maskBits);
            ByteVector data = in.data();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), in.length()).foreach((Function1)new Serializable(this, buff, maskBits, data){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buff$1;
                private final byte[] maskBits$1;
                private final ByteVector data$2;

                public final ByteBuffer apply(int i) {
                    return this.buff$1.put((byte)(this.data$2.apply((long)i) ^ this.maskBits$1[i & 3]));
                }
                {
                    this.buff$1 = buff$1;
                    this.maskBits$1 = maskBits$1;
                    this.data$2 = data$2;
                }
            });
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff});
        } else {
            buff.flip();
            byteBufferArray = (ByteBuffer[])((Object[])new ByteBuffer[]{buff, in.data().toByteBuffer()});
        }
        return byteBufferArray;
    }

    public WebSocketFrame bufferToFrame(ByteBuffer in) {
        WebSocketFrame webSocketFrame;
        if (in.remaining() < 2 || FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMsgLength(in) < 0) {
            webSocketFrame = null;
        } else {
            byte[] byArray;
            boolean masked;
            int opcode = in.get(0) & package$.MODULE$.OP_CODE();
            boolean finished = (in.get(0) & package$.MODULE$.FINISHED()) != 0;
            boolean bl = masked = (in.get(1) & package$.MODULE$.MASK()) != 0;
            if (masked && this.isClient()) {
                throw new TranscodeError("Client received a masked message");
            }
            int bodyOffset = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$lengthOffset(in);
            if (masked) {
                bodyOffset += 4;
                byArray = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$getMask(in);
            } else {
                byArray = null;
            }
            byte[] m = byArray;
            int oldLim = in.limit();
            int bodylen = FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$bodyLength(in);
            in.position(bodyOffset);
            in.limit(in.position() + bodylen);
            ByteBuffer slice = in.slice();
            in.position(in.limit());
            in.limit(oldLim);
            webSocketFrame = package$.MODULE$.makeFrame(opcode, ByteVector$.MODULE$.view(FrameTranscoder$.MODULE$.org$http4s$websocket$FrameTranscoder$$decodeBinary(slice, m)), finished);
        }
        return webSocketFrame;
    }

    public FrameTranscoder(boolean isClient) {
        this.isClient = isClient;
    }

    public static final class TranscodeError
    extends Exception {
        private final String message;

        public String message() {
            return this.message;
        }

        public TranscodeError(String message) {
            this.message = message;
            super(message);
        }
    }
}

