/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import org.http4s.websocket.WebSocketHandshake;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WebSocketHandshake$ {
    public static final WebSocketHandshake$ MODULE$;
    private final byte[] magicString;
    private final List<Tuple2<String, String>> org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders;

    static {
        new WebSocketHandshake$();
    }

    public WebSocketHandshake.ClientHandshaker clientHandshaker(String host2) {
        return new WebSocketHandshake.ClientHandshaker(host2);
    }

    public Either<Tuple2<Object, String>, Seq<Tuple2<String, String>>> serverHandshake(Iterable<Tuple2<String, String>> headers) {
        return headers.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$5) {
                Tuple2<String, String> tuple2 = x0$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    boolean bl = k.equalsIgnoreCase("Host");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }) ? (headers.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$6) {
                Tuple2<String, String> tuple2 = x0$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    boolean bl = k.equalsIgnoreCase("Connection") && WebSocketHandshake$.MODULE$.valueContains("Upgrade", v);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }) ? (headers.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$7) {
                Tuple2<String, String> tuple2 = x0$7;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    boolean bl = k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }) ? (headers.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$8) {
                Tuple2<String, String> tuple2 = x0$8;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    boolean bl = k.equalsIgnoreCase("Sec-WebSocket-Version") && WebSocketHandshake$.MODULE$.valueContains("13", v);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }) ? (Either)headers.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$9) {
                Tuple2<String, String> tuple2 = x0$9;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    boolean bl = k.equalsIgnoreCase("Sec-WebSocket-Key") && WebSocketHandshake$.MODULE$.org$http4s$websocket$WebSocketHandshake$$decodeLen(v) == 16;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Right<Nothing$, Seq<Tuple2<String, String>>> apply(Tuple2<String, String> x0$10) {
                Tuple2<String, String> tuple2 = x0$10;
                if (tuple2 != null) {
                    String v = (String)tuple2._2();
                    Seq respHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Upgrade", (Object)"websocket"), new Tuple2((Object)"Connection", (Object)"Upgrade"), new Tuple2((Object)"Sec-WebSocket-Accept", (Object)WebSocketHandshake$.MODULE$.org$http4s$websocket$WebSocketHandshake$$genAcceptKey(v))}));
                    Right right = package$.MODULE$.Right().apply((Object)respHeaders);
                    return right;
                }
                throw new MatchError(tuple2);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Left<Tuple2<Object, String>, Nothing$> apply() {
                return package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Sec-WebSocket-Key header"));
            }
        }) : package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Websocket Version header"))) : package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Upgrade header"))) : package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Bad Connection header"))) : package$.MODULE$.Left().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"Missing Host Header"));
    }

    public boolean isWebSocketRequest(Iterable<Tuple2<String, String>> headers) {
        return headers.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$11) {
                Tuple2<String, String> tuple2 = x0$11;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    boolean bl = k.equalsIgnoreCase("Upgrade") && v.equalsIgnoreCase("websocket");
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public int org$http4s$websocket$WebSocketHandshake$$decodeLen(String key) {
        return Base64.getDecoder().decode(key).length;
    }

    public String org$http4s$websocket$WebSocketHandshake$$genAcceptKey(String str) {
        MessageDigest crypt = MessageDigest.getInstance("SHA-1");
        crypt.reset();
        crypt.update(str.getBytes(StandardCharsets.US_ASCII));
        crypt.update(this.magicString());
        byte[] bytes = crypt.digest();
        return Base64.getEncoder().encodeToString(bytes);
    }

    public boolean valueContains(String key, String value2) {
        String[] parts = (String[])Predef$.MODULE$.refArrayOps((Object[])value2.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.refArrayOps((Object[])parts).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(key){
            public static final long serialVersionUID = 0L;
            private final String key$1;

            public final boolean apply(boolean b, String s2) {
                return b || s2.equalsIgnoreCase(this.key$1) || s2.length() > 1 && s2.startsWith("\"") && s2.endsWith("\"") && s2.substring(1, s2.length() - 1).equalsIgnoreCase(this.key$1);
            }
            {
                this.key$1 = key$1;
            }
        }));
    }

    private byte[] magicString() {
        return this.magicString;
    }

    public List<Tuple2<String, String>> org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders() {
        return this.org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders;
    }

    private WebSocketHandshake$() {
        MODULE$ = this;
        this.magicString = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.US_ASCII);
        this.org$http4s$websocket$WebSocketHandshake$$clientBaseHeaders = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Connection", (Object)"Upgrade"), new Tuple2((Object)"Upgrade", (Object)"websocket"), new Tuple2((Object)"Sec-WebSocket-Version", (Object)"13")}));
    }
}

