/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.utilities.http4sclienttest;

import cats.effect.Bracket;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Timer;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Vault;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import net.shrine.utilities.http4sclienttest.Http4sClientTest;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;
import org.http4s.EntityDecoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.MediaRange;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.client.asynchttpclient.AsyncHttpClient$;
import org.http4s.headers.Accept;
import org.http4s.headers.Accept$;
import org.http4s.headers.MediaRangeAndQValue;
import org.http4s.headers.MediaRangeAndQValue$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

public final class Http4sClientTest$ {
    public static final Http4sClientTest$ MODULE$;

    static {
        new Http4sClientTest$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        try {
            String urlString;
            Either uri;
            if (args.length != 2) {
                throw new Http4sClientTest.WrongNumberOfArguments("Requires two arguments: the http verb (PUT or GET) and the URL to call.");
            }
            String verbString = args[0];
            Either verb = Method$.MODULE$.fromString(verbString);
            Tuple2 tuple2 = new Tuple2((Object)verb, (Object)(uri = Uri$.MODULE$.fromString(urlString = args[1])));
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Either either2 = (Either)tuple2._2();
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Method v = (Method)right.b();
                    if (either2 instanceof Right) {
                        Right right2 = (Right)either2;
                        Uri u = (Uri)right2.b();
                        IO<String> requestResponseIo = this.testHttpRequest(v, u);
                        requestResponseIo.unsafeRunTimed((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds()).fold((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                Predef$.MODULE$.println((Object)"No response after 30 seconds");
                            }
                        }, (Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final void apply(String x$1) {
                                Predef$.MODULE$.println((Object)x$1);
                            }
                        });
                        System.exit(0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"something went wrong with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(2);
            return;
        }
        catch (Http4sClientTest.WrongNumberOfArguments wrongNumberOfArguments) {
            this.printUsage();
            System.exit(1);
        }
    }

    public void printUsage() {
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Usage: ./http4sClientTest VERB URL\n        |\n        |Try the URL using the http VERB via the http4s client. This is primarily meant to test the http4s client in\n        |environments with https client-side proxies, and to detect other potential obsticals between a downstream node\n        |and a hub in a SHRINE network.\n        |\n        |Exit codes: 0 success\n        |            1 known error\n        |            2 unknown error (with an accompanying stack trace).\n        |\n        |Examples:\n        |./http4sClientTest GET https://shrine-dev1.catalyst:6443/shrine-api/mom/getQueues\n        |./http4sClientTest PUT https://shrine-dev1.catalyst:6443/shrine-api/mom/createQueue/HarmlessTestQueue\n      ")).stripMargin());
    }

    public IO<String> testHttpRequest(Method verb, Uri uri) {
        Tuple2 tuple2;
        block4: {
            DefaultAsyncHttpClientConfig defaultAsyncHttpClientConfig;
            block3: {
                SslContext sslContext;
                block2: {
                    Option proxyPort;
                    sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                    Option proxyHost = Option$.MODULE$.apply((Object)System.getProperty("http.proxyHost"));
                    tuple2 = new Tuple2((Object)proxyHost, (Object)(proxyPort = Option$.MODULE$.apply((Object)System.getProperty("http.proxyPort")).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final int apply(String x$2) {
                            return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
                        }
                    })));
                    if (tuple2 == null) break block2;
                    Option option = (Option)tuple2._1();
                    Option option2 = (Option)tuple2._2();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String host = (String)some.x();
                    if (!(option2 instanceof Some)) break block2;
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt((Object)some2.x());
                    ProxyServer proxyServer = new ProxyServer.Builder(host, port).build();
                    defaultAsyncHttpClientConfig = Dsl.config().setSslContext(sslContext).setProxyServer(proxyServer).build();
                    break block3;
                }
                if (tuple2 == null) break block4;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option) || !None$.MODULE$.equals(option3)) break block4;
                defaultAsyncHttpClientConfig = Dsl.config().setSslContext(sslContext).build();
            }
            DefaultAsyncHttpClientConfig config = defaultAsyncHttpClientConfig;
            Timer timer = IO$.MODULE$.timer((ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            ContextShift concurrentEffect = IO$.MODULE$.contextShift((ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            Client httpClient = (Client)((IO)AsyncHttpClient$.MODULE$.resource((AsyncHttpClientConfig)config, IO$.MODULE$.ioConcurrentEffect(concurrentEffect)).use((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final IO<Client<IO>> apply(Client<IO> client) {
                    return IO$.MODULE$.apply((Function0)new Serializable(this, client){
                        public static final long serialVersionUID = 0L;
                        private final Client client$1;

                        public final Client<IO> apply() {
                            return this.client$1;
                        }
                        {
                            this.client$1 = client$1;
                        }
                    });
                }
            }, (Bracket)IO$.MODULE$.ioConcurrentEffect(concurrentEffect))).unsafeRunSync();
            Accept acceptHeader = (Accept)Accept$.MODULE$.apply((Object)MediaRangeAndQValue$.MODULE$.withDefaultQValue((MediaRange)MediaType$.MODULE$.application().json()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new MediaRangeAndQValue[0]));
            Method x$3 = verb;
            Uri x$4 = uri;
            List x$5 = Headers$.MODULE$.of((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Header[]{acceptHeader}));
            HttpVersion x$6 = Request$.MODULE$.apply$default$3();
            FreeC x$7 = Request$.MODULE$.apply$default$5();
            Vault x$8 = Request$.MODULE$.apply$default$6();
            Request request = Request$.MODULE$.apply(x$3, x$4, x$6, x$5, x$7, x$8);
            return (IO)httpClient.expect(request, EntityDecoder$.MODULE$.text((Sync)IO$.MODULE$.ioConcurrentEffect(concurrentEffect), EntityDecoder$.MODULE$.text$default$2()));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only one of http.proxyHost and http.proxyPort set ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple2})));
    }

    private Http4sClientTest$() {
        MODULE$ = this;
    }
}

