/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.function.Consumer;

final class Signal {
    private static final MethodHandle SIGNAL_CONSTRUCTOR_METHOD_HANDLE;
    private static final MethodHandle HANDLE_STATIC_METHOD_HANDLE;
    private static final SignalHandler SIGNAL_HANDLER;

    private Signal() {
    }

    static void handle(String string, Consumer<Object> consumer) {
        SIGNAL_HANDLER.handle(string, consumer);
    }

    private static final Class<?> findClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static final MethodHandle initSignalConstructorMethodHandle(MethodHandles.Lookup lookup, Class<?> clazz) {
        MethodType methodType = MethodType.methodType(Void.TYPE, String.class);
        try {
            return lookup.findConstructor(clazz, methodType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final MethodHandle initHandleStaticMethodHandle(MethodHandles.Lookup lookup, Class<?> clazz, Class<?> clazz2) {
        MethodType methodType = MethodType.methodType(clazz2, clazz, clazz2);
        try {
            return lookup.findStatic(clazz, "handle", methodType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final InvocationHandler invocationHandlerFromConsumer(Consumer<Object> consumer) {
        return (object, method, objectArray) -> {
            consumer.accept(objectArray[0]);
            return null;
        };
    }

    private static final SignalHandler initSignalHandler(final Class<?> clazz) {
        return new SignalHandler(){

            @Override
            final void handle(String string, Consumer<Object> consumer) {
                InvocationHandler invocationHandler = Signal.invocationHandlerFromConsumer(consumer);
                Object object = Proxy.newProxyInstance(Signal.class.getClassLoader(), new Class[]{clazz}, invocationHandler);
                try {
                    Object object2 = SIGNAL_CONSTRUCTOR_METHOD_HANDLE.invoke(string);
                    HANDLE_STATIC_METHOD_HANDLE.invoke(object2, object);
                }
                finally {
                    return;
                }
            }
        };
    }

    static {
        boolean bl;
        Class<?> clazz = Signal.findClass("sun.misc.Signal");
        Class<?> clazz2 = Signal.findClass("sun.misc.SignalHandler");
        boolean bl2 = bl = clazz != null && clazz2 != null;
        if (bl) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SIGNAL_CONSTRUCTOR_METHOD_HANDLE = Signal.initSignalConstructorMethodHandle(lookup, clazz);
            HANDLE_STATIC_METHOD_HANDLE = Signal.initHandleStaticMethodHandle(lookup, clazz, clazz2);
            SIGNAL_HANDLER = Signal.initSignalHandler(clazz2);
        } else {
            SIGNAL_CONSTRUCTOR_METHOD_HANDLE = null;
            HANDLE_STATIC_METHOD_HANDLE = null;
            SIGNAL_HANDLER = new SignalHandler(){

                @Override
                final void handle(String string, Consumer<Object> consumer) {
                }
            };
        }
    }

    static abstract class SignalHandler {
        SignalHandler() {
        }

        abstract void handle(String var1, Consumer<Object> var2);
    }
}

