/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.ArrayStack$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000514A!\u0006\f\u00077!A1\u0005\u0001B\u0001B\u0003&A\u0005\u0003\u0005(\u0001\t\u0005\t\u0015)\u0003)\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u0015Y\u0003\u0001\"\u0001:\u0011\u0015Y\u0003\u0001\"\u0001=\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015Q\u0005\u0001\"\u0001J\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0019Q\u0006\u0001)C\u00053\u001e)1L\u0006E\u00059\u001a)QC\u0006E\u0005;\")1&\u0005C\u0001=\")q,\u0005C\u0001A\")q,\u0005C\u0001K\nQ\u0011I\u001d:bsN#\u0018mY6\u000b\u0005]A\u0012AB3gM\u0016\u001cGOC\u0001\u001a\u0003\u0011\u0019\u0017\r^:\u0004\u0001U\u0011A$M\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0017A\u00022vM\u001a,'\u000fE\u0002\u001fKuI!AJ\u0010\u0003\u000b\u0005\u0013(/Y=\u0002\u000b%tG-\u001a=\u0011\u0005yI\u0013B\u0001\u0016 \u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075:\u0004\bE\u0002/\u0001=j\u0011A\u0006\t\u0003aEb\u0001\u0001B\u00033\u0001\t\u00071GA\u0001B#\t!T\u0004\u0005\u0002\u001fk%\u0011ag\b\u0002\b\u001d>$\b.\u001b8h\u0011\u0015\u00193\u00011\u0001%\u0011\u001593\u00011\u0001))\ti#\bC\u0003<\t\u0001\u0007\u0001&A\u0005j]&$(i\\;oIR\tQ&\u0001\u0003j]&$HCA C!\tq\u0002)\u0003\u0002B?\t!QK\\5u\u0011\u0015\u0019e\u00011\u0001)\u0003\u0015\u0011w.\u001e8e\u0003\u0011\u0001Xo\u001d5\u0015\u0005}2\u0005\"B$\b\u0001\u0004y\u0013!A1\u0002\u0007A|\u0007\u000fF\u00010\u0003\u0011\u0001X-Z6\u0002\u000f%\u001cX)\u001c9usR\tQ\n\u0005\u0002\u001f\u001d&\u0011qj\b\u0002\b\u0005>|G.Z1o\u00031)hn]1gK\n+hMZ3s)\u0005!\u0013aC;og\u00064W-\u00138eKb$\u0012\u0001K\u0001\nk:\u001c\u0018MZ3TKR$\"a\u0010,\t\u000b]k\u0001\u0019\u0001\u0015\u0002\t9,w/S\u0001\u000bS:4\u0018\r\\5eCR,G#A \u0002\u0019\rDWmY6B]\u0012<%o\\<\u0002\u0015\u0005\u0013(/Y=Ti\u0006\u001c7\u000e\u0005\u0002/#M\u0011\u0011#\b\u000b\u00029\u0006)\u0011\r\u001d9msV\u0011\u0011\r\u001a\u000b\u0002EB\u0019a\u0006A2\u0011\u0005A\"G!\u0002\u001a\u0014\u0005\u0004\u0019TC\u00014j)\t9'\u000eE\u0002/\u0001!\u0004\"\u0001M5\u0005\u000bI\"\"\u0019A\u001a\t\u000b-$\u0002\u0019\u0001\u0015\u0002\tML'0\u001a")
public final class ArrayStack<A> {
    private Object[] buffer;
    private int index;

    public static <A> ArrayStack<A> apply(int size) {
        return ArrayStack$.MODULE$.apply(size);
    }

    public static <A> ArrayStack<A> apply() {
        return ArrayStack$.MODULE$.apply();
    }

    public void init(int bound) {
        this.buffer = new Object[bound];
        this.index = 0;
    }

    public void push(A a) {
        this.checkAndGrow();
        this.buffer[this.index] = a;
        ++this.index;
    }

    public A pop() {
        --this.index;
        Object back = this.buffer[this.index];
        this.buffer[this.index] = null;
        return (A)back;
    }

    public A peek() {
        return (A)this.buffer[this.index - 1];
    }

    public boolean isEmpty() {
        return this.index <= 0;
    }

    public Object[] unsafeBuffer() {
        return this.buffer;
    }

    public int unsafeIndex() {
        return this.index;
    }

    public void unsafeSet(int newI) {
        for (int i = newI; i < this.index; ++i) {
            this.buffer[i] = null;
        }
        this.index = newI;
    }

    public void invalidate() {
        this.index = 0;
        this.buffer = null;
    }

    private void checkAndGrow() {
        if (this.index >= this.buffer.length) {
            int len = this.buffer.length;
            Object[] buffer2 = new Object[len * 2];
            System.arraycopy(this.buffer, 0, buffer2, 0, len);
            this.buffer = buffer2;
            return;
        }
    }

    public ArrayStack(Object[] buffer, int index) {
        this.buffer = buffer;
        this.index = index;
    }

    public ArrayStack(int initBound) {
        this(new Object[initBound], 0);
    }

    public ArrayStack() {
        this(null, 0);
    }
}

