/*
 * Decompiled with CFR 0.152.
 */
package org.http4s;

import cats.Foldable;
import cats.Functor;
import cats.Monad;
import cats.Semigroupal;
import cats.data.OptionT;
import cats.data.OptionT$;
import cats.effect.ContextShift;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.implicits$;
import cats.kernel.Semigroup;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.io.file.package$;
import io.chrisdavenport.vault.Key;
import io.chrisdavenport.vault.Key$;
import io.chrisdavenport.vault.Vault;
import io.chrisdavenport.vault.Vault$;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import org.http4s.ContentCoding$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.HttpDate$;
import org.http4s.HttpVersion;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.TransferCoding;
import org.http4s.TransferCoding$;
import org.http4s.headers.Accept$minusEncoding;
import org.http4s.headers.Accept$minusEncoding$;
import org.http4s.headers.Content$minusEncoding;
import org.http4s.headers.Content$minusLength;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Content$minusType;
import org.http4s.headers.Content$minusType$;
import org.http4s.headers.ETag;
import org.http4s.headers.ETag$;
import org.http4s.headers.If$minusModified$minusSince;
import org.http4s.headers.If$minusModified$minusSince$;
import org.http4s.headers.If$minusNone$minusMatch;
import org.http4s.headers.If$minusNone$minusMatch$;
import org.http4s.headers.Last$minusModified;
import org.http4s.headers.Transfer$minusEncoding$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

public final class StaticFile$ {
    public static StaticFile$ MODULE$;
    private final Logger logger;
    private final int DefaultBufferSize;
    private final Key<File> staticFileKey;

    static {
        new StaticFile$();
    }

    public int DefaultBufferSize() {
        return this.DefaultBufferSize;
    }

    public <F> OptionT<F, Response<F>> fromString(String url, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> evidence$1, ContextShift<F> evidence$2) {
        return this.fromFile(new File(url), blockingExecutionContext, req, evidence$1, evidence$2);
    }

    public <F> None$ fromString$default$3() {
        return None$.MODULE$;
    }

    public <F> OptionT<F, Response<F>> fromResource(String name, ExecutionContext blockingExecutionContext, Option<Request<F>> req, boolean preferGzipped, Sync<F> evidence$3, ContextShift<F> evidence$4) {
        boolean tryGzipped = preferGzipped && req.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Headers$.MODULE$.get$extension0((List<Header>)x$1.headers(), Accept$minusEncoding$.MODULE$)).exists((Function1 & Serializable & scala.Serializable)acceptEncoding -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$fromResource$2(acceptEncoding)));
        OptionT gzUrl = tryGzipped ? new OptionT(Sync$.MODULE$.apply(evidence$3).delay((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)MODULE$.getClass().getResource(new StringBuilder(3).append(name).append(".gz").toString())))) : OptionT$.MODULE$.none(evidence$3);
        return gzUrl.flatMap((Function1 & Serializable & scala.Serializable)url -> {
            Option<Content$minusType> contentType = MODULE$.nameToContentType(name);
            Content$minusEncoding content$minusEncoding = new Content$minusEncoding(ContentCoding$.MODULE$.gzip());
            List headers = contentType.toList().$colon$colon((Object)content$minusEncoding);
            return MODULE$.fromURL((URL)url, blockingExecutionContext, req, evidence$3, evidence$4).map((Function1 & Serializable & scala.Serializable)x$3 -> (Response)x$3.removeHeader(Content$minusType$.MODULE$).putHeaders((Seq<Header>)headers), (Functor)evidence$3);
        }, evidence$3).orElse((Function0 & Serializable & scala.Serializable)() -> new OptionT(Sync$.MODULE$.apply(evidence$3).delay((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)MODULE$.getClass().getResource(name)))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.fromURL((URL)x$4, blockingExecutionContext, req, evidence$3, evidence$4), (Monad)evidence$3), evidence$3);
    }

    public <F> None$ fromResource$default$3() {
        return None$.MODULE$;
    }

    public <F> boolean fromResource$default$4() {
        return false;
    }

    public <F> OptionT<F, Response<F>> fromURL(URL url, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> F, ContextShift<F> cs) {
        return OptionT$.MODULE$.liftF(F.delay((Function0 & Serializable & scala.Serializable)() -> {
            Response response;
            URLConnection urlConn = url.openConnection();
            Option lastmod = HttpDate$.MODULE$.fromEpochSecond(urlConn.getLastModified() / 1000L).toOption();
            Option ifModifiedSince = req.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Headers$.MODULE$.get$extension0((List<Header>)x$5.headers(), If$minusModified$minusSince$.MODULE$));
            boolean expired = BoxesRunTime.unboxToBoolean((Object)((Option)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)ifModifiedSince, (Object)lastmod)).mapN((Function2 & Serializable & scala.Serializable)(x$6, x$7) -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$fromURL$3(x$6, x$7)), (Functor)implicits$.MODULE$.catsStdInstancesForOption(), (Semigroupal)implicits$.MODULE$.catsStdInstancesForOption())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            if (expired) {
                List<Header> headers;
                Content$minusLength lenHeader;
                List lastModHeader = lastmod.map((Function1 & Serializable & scala.Serializable)x$8 -> new Last$minusModified((HttpDate)x$8)).toList();
                List contentType = MODULE$.nameToContentType(url.getPath()).toList();
                long len = urlConn.getContentLengthLong();
                Content$minusLength content$minusLength = lenHeader = len >= 0L ? Content$minusLength$.MODULE$.unsafeFromLong(len) : Transfer$minusEncoding$.MODULE$.apply(TransferCoding$.MODULE$.chunked(), (Seq<Object>)Predef$.MODULE$.wrapRefArray((Object[])new TransferCoding[0]));
                List list = lastModHeader;
                List<Header> x$1 = headers = Headers$.MODULE$.apply((List<Header>)contentType.$colon$colon$colon(list).$colon$colon((Object)content$minusLength));
                FreeC x$2 = fs2.io.package$.MODULE$.readInputStream(F.delay((Function0 & Serializable & scala.Serializable)() -> url.openStream()), MODULE$.DefaultBufferSize(), blockingExecutionContext, fs2.io.package$.MODULE$.readInputStream$default$4(), F, cs);
                Status x$3 = Response$.MODULE$.apply$default$1();
                HttpVersion x$4 = Response$.MODULE$.apply$default$2();
                Vault x$52 = Response$.MODULE$.apply$default$5();
                response = new Response(x$3, x$4, x$1, x$2, x$52);
            } else {
                urlConn.getInputStream().close();
                response = new Response(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
            }
            return response;
        }), F);
    }

    public <F> None$ fromURL$default$3() {
        return None$.MODULE$;
    }

    public <F> Function1<File, F> calcETag(Sync<F> evidence$5) {
        return (Function1 & Serializable & scala.Serializable)f -> Sync$.MODULE$.apply(evidence$5).delay((Function0 & Serializable & scala.Serializable)() -> f.isFile() ? new StringBuilder(1).append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.lastModified()))).append("-").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(f.length()))).toString() : "");
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Sync<F> evidence$6, ContextShift<F> evidence$7) {
        return this.fromFile(f, this.DefaultBufferSize(), blockingExecutionContext, req, this.calcETag(evidence$6), evidence$6, evidence$7);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$8, ContextShift<F> evidence$9) {
        return this.fromFile(f, this.DefaultBufferSize(), blockingExecutionContext, req, etagCalculator, evidence$8, evidence$9);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, int buffsize, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> evidence$10, ContextShift<F> evidence$11) {
        return this.fromFile(f, 0L, f.length(), buffsize, blockingExecutionContext, req, etagCalculator, evidence$10, evidence$11);
    }

    public <F> OptionT<F, Response<F>> fromFile(File f, long start, long end, int buffsize, ExecutionContext blockingExecutionContext, Option<Request<F>> req, Function1<File, F> etagCalculator, Sync<F> F, ContextShift<F> cs) {
        return new OptionT(implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(etagCalculator.apply((Object)f), F).map((Function1 & Serializable & scala.Serializable)et -> ETag$.MODULE$.apply((String)et, ETag$.MODULE$.apply$default$2())), F).flatMap((Function1 & Serializable & scala.Serializable)etagCalc -> F.delay((Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            if (f.isFile()) {
                Predef$.MODULE$.require(start >= 0L && end >= start && buffsize > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("start: ").append(start).append(", end: ").append(end).append(", buffsize: ").append(buffsize).toString());
                Option lastModified = HttpDate$.MODULE$.fromEpochSecond(f.lastModified() / 1000L).toOption();
                none$ = MODULE$.notModified(req, (ETag)etagCalc, (Option<HttpDate>)lastModified).orElse((Function0 & Serializable & scala.Serializable)() -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = tuple2 = f.length() < end ? new Tuple2((Object)new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.empty()))), (Object)BoxesRunTime.boxToLong((long)0L)) : new Tuple2((Object)new Stream(MODULE$.fileToBody(f, start, end, blockingExecutionContext, F, cs)), (Object)BoxesRunTime.boxToLong((long)(end - start)));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    FreeC body = ((Stream)tuple2._1()).fs2$Stream$$free();
                    long contentLength = tuple2._2$mcJ$sp();
                    Tuple2 tuple23 = new Tuple2((Object)new Stream(body), (Object)BoxesRunTime.boxToLong((long)contentLength));
                    Tuple2 tuple24 = tuple23;
                    FreeC body2 = ((Stream)tuple24._1()).fs2$Stream$$free();
                    long contentLength2 = tuple24._2$mcJ$sp();
                    Option<Content$minusType> contentType = MODULE$.nameToContentType(f.getName());
                    List list = lastModified.map((Function1 & Serializable & scala.Serializable)lm -> new Last$minusModified((HttpDate)lm)).toList();
                    List list2 = implicits$.MODULE$.toFoldableOps(Content$minusLength$.MODULE$.fromLong(contentLength2), (Foldable)implicits$.MODULE$.catsStdInstancesForEither()).toList();
                    List list3 = contentType.toList();
                    List hs = new .colon.colon(etagCalc, (List)Nil$.MODULE$).$colon$colon$colon(list3).$colon$colon$colon(list2).$colon$colon$colon(list);
                    List<Header> x$1 = Headers$.MODULE$.apply((List<Header>)hs);
                    FreeC x$2 = body2;
                    Vault x$3 = Vault$.MODULE$.empty().insert(MODULE$.staticFileKey(), (Object)f);
                    Status x$4 = Response$.MODULE$.apply$default$1();
                    HttpVersion x$5 = Response$.MODULE$.apply$default$2();
                    Response r = new Response(x$4, x$5, x$1, x$2, x$3);
                    if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
                        StaticFile$.MODULE$.logger.trace(new StringBuilder(32).append("Static file generated response: ").append(r).toString());
                    }
                    return new Some(r);
                });
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        })));
    }

    public <F> None$ fromFile$default$3() {
        return None$.MODULE$;
    }

    private <F> Option<Response<F>> notModified(Option<Request<F>> req, ETag etagCalc, Option<HttpDate> lastModified) {
        Semigroup<Object> conjunction = new Semigroup<Object>(){

            public double combine$mcD$sp(double x, double y) {
                return Semigroup.combine$mcD$sp$((Semigroup)this, (double)x, (double)y);
            }

            public float combine$mcF$sp(float x, float y) {
                return Semigroup.combine$mcF$sp$((Semigroup)this, (float)x, (float)y);
            }

            public int combine$mcI$sp(int x, int y) {
                return Semigroup.combine$mcI$sp$((Semigroup)this, (int)x, (int)y);
            }

            public long combine$mcJ$sp(long x, long y) {
                return Semigroup.combine$mcJ$sp$((Semigroup)this, (long)x, (long)y);
            }

            public Object combineN(Object a, int n) {
                return Semigroup.combineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double combineN$mcD$sp(double a, int n) {
                return Semigroup.combineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float combineN$mcF$sp(float a, int n) {
                return Semigroup.combineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int combineN$mcI$sp(int a, int n) {
                return Semigroup.combineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long combineN$mcJ$sp(long a, int n) {
                return Semigroup.combineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Object repeatedCombineN(Object a, int n) {
                return Semigroup.repeatedCombineN$((Semigroup)this, (Object)a, (int)n);
            }

            public double repeatedCombineN$mcD$sp(double a, int n) {
                return Semigroup.repeatedCombineN$mcD$sp$((Semigroup)this, (double)a, (int)n);
            }

            public float repeatedCombineN$mcF$sp(float a, int n) {
                return Semigroup.repeatedCombineN$mcF$sp$((Semigroup)this, (float)a, (int)n);
            }

            public int repeatedCombineN$mcI$sp(int a, int n) {
                return Semigroup.repeatedCombineN$mcI$sp$((Semigroup)this, (int)a, (int)n);
            }

            public long repeatedCombineN$mcJ$sp(long a, int n) {
                return Semigroup.repeatedCombineN$mcJ$sp$((Semigroup)this, (long)a, (int)n);
            }

            public Option<Object> combineAllOption(TraversableOnce<Object> as) {
                return Semigroup.combineAllOption$((Semigroup)this, as);
            }

            public boolean combine(boolean x, boolean y) {
                return x && y;
            }
            {
                Semigroup.$init$((Semigroup)this);
            }
        };
        return ((Option)implicits$.MODULE$.toFoldableOps((Object)new .colon.colon(this.etagMatch(req, etagCalc), (List)new .colon.colon(this.notModifiedSince(req, lastModified), (List)Nil$.MODULE$)), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).combineAll(implicits$.MODULE$.catsKernelStdMonoidForOption((Semigroup)conjunction))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$notModified$1(BoxesRunTime.unboxToBoolean((Object)x)))).map((Function1 & Serializable & scala.Serializable)x$15 -> StaticFile$.$anonfun$notModified$2(BoxesRunTime.unboxToBoolean((Object)x$15)));
    }

    private <F> Option<Object> etagMatch(Option<Request<F>> req, ETag etagCalc) {
        return req.flatMap((Function1 & Serializable & scala.Serializable)r -> Headers$.MODULE$.get$extension0((List<Header>)r.headers(), If$minusNone$minusMatch$.MODULE$).map((Function1 & Serializable & scala.Serializable)etagHeader -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$etagMatch$2(etagCalc, etagHeader))));
    }

    private <F> Option<Object> notModifiedSince(Option<Request<F>> req, Option<HttpDate> lastModified) {
        return req.flatMap((Function1 & Serializable & scala.Serializable)r -> Headers$.MODULE$.get$extension0((List<Header>)r.headers(), If$minusModified$minusSince$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)h -> lastModified.map((Function1 & Serializable & scala.Serializable)lm -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$notModifiedSince$3(h, lm)))));
    }

    private <F> FreeC<?, BoxedUnit> fileToBody(File f, long start, long end, ExecutionContext blockingExecutionContext, Sync<F> evidence$12, ContextShift<F> evidence$13) {
        return package$.MODULE$.readRange(f.toPath(), blockingExecutionContext, this.DefaultBufferSize(), start, end, evidence$12, evidence$13);
    }

    private Option<Content$minusType> nameToContentType(String name) {
        None$ none$;
        int n = name.lastIndexOf(46);
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                none$ = MediaType$.MODULE$.forExtension(name.substring(n + 1)).map((Function1 & Serializable & scala.Serializable)x$22 -> Content$minusType$.MODULE$.apply((MediaType)x$22));
                break;
            }
        }
        return none$;
    }

    public Key<File> staticFileKey() {
        return this.staticFileKey;
    }

    public static final /* synthetic */ boolean $anonfun$fromResource$2(Accept$minusEncoding acceptEncoding) {
        return acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.gzip()) || acceptEncoding.satisfiedBy(ContentCoding$.MODULE$.x$minusgzip());
    }

    public static final /* synthetic */ boolean $anonfun$fromURL$3(If$minusModified$minusSince x$6, HttpDate x$7) {
        return x$6.date().$less(x$7);
    }

    public static final /* synthetic */ boolean $anonfun$notModified$1(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ Response $anonfun$notModified$2(boolean x$15) {
        return new Response(Status$.MODULE$.NotModified(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$etagMatch$4(ETag etagCalc$2, ETag.EntityTag x$17) {
        ETag.EntityTag entityTag = x$17;
        ETag.EntityTag entityTag2 = etagCalc$2.tag();
        return !(entityTag != null ? !((Object)entityTag).equals(entityTag2) : entityTag2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$etagMatch$2(ETag etagCalc$2, If$minusNone$minusMatch etagHeader) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean etagMatch = etagHeader.tags().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)StaticFile$.$anonfun$etagMatch$4(etagCalc$2, x$17)))));
        if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
            StaticFile$.MODULE$.logger.trace(new StringBuilder(53).append("Matches `If-None-Match`: ").append(etagMatch).append(" Previous ETag: ").append(etagHeader.value()).append(", New ETag: ").append(etagCalc$2).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$notModifiedSince$3(If$minusModified$minusSince h$1, HttpDate lm) {
        void var2_2;
        BoxedUnit boxedUnit;
        boolean notModified = h$1.date().$greater$eq(lm);
        if (StaticFile$.MODULE$.logger.isTraceEnabled()) {
            StaticFile$.MODULE$.logger.trace(new StringBuilder(56).append("Matches `If-Modified-Since`: ").append(notModified).append(". Request age: ").append(h$1.date()).append(", Modified: ").append(lm).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
        return (boolean)var2_2;
    }

    private StaticFile$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.StaticFile");
        this.DefaultBufferSize = 10240;
        this.staticFileKey = (Key)((IO)Key$.MODULE$.newKey((Sync)IO$.MODULE$.ioEffect())).unsafeRunSync();
    }
}

