/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoinStringIndex;
import com.opencsv.bean.BeanFieldSingleValue;
import com.opencsv.bean.BeanFieldSplit;
import com.opencsv.bean.CsvBindAndJoinByName;
import com.opencsv.bean.CsvBindAndSplitByName;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.CsvCustomBindByName;
import com.opencsv.bean.HeaderNameBaseMappingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;

public class HeaderColumnNameMappingStrategy<T>
extends HeaderNameBaseMappingStrategy<T> {
    @Override
    protected void loadAnnotatedFieldMap(ListValuedMap<Class<?>, Field> fields) {
        for (Map.Entry classField : fields.entries()) {
            String format;
            String capture;
            String writeLocale;
            String locale;
            boolean required;
            Object converter;
            String columnName;
            Annotation annotation;
            Class localType = (Class)classField.getKey();
            Field localField = (Field)classField.getValue();
            if (localField.isAnnotationPresent(CsvCustomBindByName.class)) {
                annotation = localField.getAnnotation(CsvCustomBindByName.class);
                columnName = annotation.column().toUpperCase().trim();
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    columnName = localField.getName().toUpperCase();
                }
                converter = localField.getAnnotation(CsvCustomBindByName.class).converter();
                BeanField bean = this.instantiateCustomConverter(converter);
                bean.setType(localType);
                bean.setField(localField);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(columnName, bean);
                continue;
            }
            if (localField.isAnnotationPresent(CsvBindAndSplitByName.class)) {
                annotation = localField.getAnnotation(CsvBindAndSplitByName.class);
                required = annotation.required();
                columnName = annotation.column().toUpperCase().trim();
                locale = annotation.locale();
                writeLocale = annotation.writeLocaleEqualsReadLocale() ? locale : annotation.writeLocale();
                String splitOn = annotation.splitOn();
                String writeDelimiter = annotation.writeDelimiter();
                Class<? extends Collection> collectionType = annotation.collectionType();
                Class<?> elementType = annotation.elementType();
                Class<? extends AbstractCsvConverter> splitConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter2 = this.determineConverter(localField, elementType, locale, writeLocale, splitConverter);
                if (StringUtils.isEmpty((CharSequence)columnName)) {
                    this.fieldMap.put(localField.getName().toUpperCase(), new BeanFieldSplit(localType, localField, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, capture, format));
                    continue;
                }
                this.fieldMap.put(columnName, new BeanFieldSplit(localType, localField, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, capture, format));
                continue;
            }
            if (localField.isAnnotationPresent(CsvBindAndJoinByName.class)) {
                annotation = localField.getAnnotation(CsvBindAndJoinByName.class);
                required = annotation.required();
                String columnRegex = annotation.column();
                locale = annotation.locale();
                writeLocale = annotation.writeLocaleEqualsReadLocale() ? locale : annotation.writeLocale();
                Class<?> elementType = annotation.elementType();
                Class<? extends MultiValuedMap> mapType = annotation.mapType();
                Class<? extends AbstractCsvConverter> joinConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter3 = this.determineConverter(localField, elementType, locale, writeLocale, joinConverter);
                if (StringUtils.isEmpty((CharSequence)columnRegex)) {
                    this.fieldMap.putComplex(localField.getName(), new BeanFieldJoinStringIndex(localType, localField, required, this.errorLocale, converter3, mapType, capture, format));
                    continue;
                }
                this.fieldMap.putComplex(columnRegex, new BeanFieldJoinStringIndex(localType, localField, required, this.errorLocale, converter3, mapType, capture, format));
                continue;
            }
            annotation = localField.getAnnotation(CsvBindByName.class);
            required = annotation.required();
            columnName = annotation.column().toUpperCase().trim();
            locale = annotation.locale();
            writeLocale = annotation.writeLocaleEqualsReadLocale() ? locale : annotation.writeLocale();
            capture = annotation.capture();
            format = annotation.format();
            converter = this.determineConverter(localField, localField.getType(), locale, writeLocale, null);
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                this.fieldMap.put(localField.getName().toUpperCase(), new BeanFieldSingleValue(localType, localField, required, this.errorLocale, (CsvConverter)converter, capture, format));
                continue;
            }
            this.fieldMap.put(columnName, new BeanFieldSingleValue(localType, localField, required, this.errorLocale, (CsvConverter)converter, capture, format));
        }
    }

    @Override
    protected Set<Class<? extends Annotation>> getBindingAnnotations() {
        return new HashSet<Class<? extends Annotation>>(Arrays.asList(CsvBindByName.class, CsvCustomBindByName.class, CsvBindAndSplitByName.class, CsvBindAndJoinByName.class));
    }
}

