/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;

class AccumulateCsvResults<T>
extends Thread {
    private final BlockingQueue<OrderedObject<T>> resultantBeansQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final ConcurrentMap<Long, T> resultantBeanMap;
    private final ConcurrentMap<Long, CsvException> thrownExceptionsMap;
    private boolean mustStop = false;

    AccumulateCsvResults(BlockingQueue<OrderedObject<T>> resultantBeansQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, ConcurrentMap<Long, T> resultantBeanMap, ConcurrentMap<Long, CsvException> thrownExceptionsMap) {
        this.resultantBeansQueue = resultantBeansQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.resultantBeanMap = resultantBeanMap;
        this.thrownExceptionsMap = thrownExceptionsMap;
    }

    private synchronized boolean isMustStop() {
        return this.mustStop;
    }

    synchronized void setMustStop(boolean mustStop) {
        this.mustStop = mustStop;
    }

    @Override
    public void run() {
        while (!(this.isMustStop() && this.resultantBeansQueue.isEmpty() && this.thrownExceptionsQueue.isEmpty())) {
            while (!this.resultantBeansQueue.isEmpty()) {
                OrderedObject bean = (OrderedObject)this.resultantBeansQueue.poll();
                if (bean == null) continue;
                this.resultantBeanMap.put(bean.getOrdinal(), bean.getElement());
            }
            while (!this.thrownExceptionsQueue.isEmpty()) {
                OrderedObject capturedException = (OrderedObject)this.thrownExceptionsQueue.poll();
                if (capturedException == null) continue;
                this.thrownExceptionsMap.put(capturedException.getOrdinal(), (CsvException)capturedException.getElement());
            }
            Thread.yield();
        }
    }
}

