package net.shrine.sheriff.controller;

import net.shrine.sheriff.view.MVC;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * [ SUMMARY ]
 * <p/>
 * [ Author ]
 * Andrew McMurry
 * Date: Jul 14, 2009
 * <p/>
 * Harvard Medical School Center for BioMedical Informatics
 *
 * @link http://cbmi.med.harvard.edu
 * <p/>
 * [ In partnership with ]
 * @link http://chip.org
 * @link http://lcs.mgh.harvard.edu
 * @link http://www.brighamandwomens.org
 * @link http://bidmc.harvard.edu
 * @link http://dfhcc.harvard.edu
 * @link http://spin.nci.nih.gov/
 * <p/>
 * <p/>
 * -------------------------------------------------
 * [ Licensing ]
 * All works licensed by the Lesser GPL
 * @link http://www.gnu.org/licenses/lgpl.html
 * -------------------------------------------------
 */
public class AdminFilter extends UIFilter
{
    protected static String filterName = AdminFilter.class.getSimpleName();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException
    {
        if(DEBUG)
        {
            log.debug(filterName + " doFilter(...)");
        }

        try
        {
            HttpSession session = ((HttpServletRequest) request).getSession(false);

            if(session != null && session.getAttribute(MVC.Session.isAdmin.name()) == Boolean.TRUE)
            {
                chain.doFilter(request, response);
            }
            else
            {
                returnError(request, response, NO_SESSION);
            }
        }
        catch(Exception e)
        {
            log.error("Failed to fulfill request for protected resource", e);
        }
    }
}