package net.shrine.sheriff.controller;

import net.shrine.sheriff.view.MVC;
import org.apache.log4j.Logger;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * [ SUMMARY ]
 * <p/>
 * [ Author ]
 * Andrew McMurry
 * Date: Jul 14, 2009
 * <p/>
 * Harvard Medical School Center for BioMedical Informatics
 *
 * @link http://cbmi.med.harvard.edu
 * <p/>
 * [ In partnership with ]
 * @link http://chip.org
 * @link http://lcs.mgh.harvard.edu
 * @link http://www.brighamandwomens.org
 * @link http://bidmc.harvard.edu
 * @link http://dfhcc.harvard.edu
 * @link http://spin.nci.nih.gov/
 * <p/>
 * <p/>
 * -------------------------------------------------
 * [ Licensing ]
 * All works licensed by the Lesser GPL
 * @link http://www.gnu.org/licenses/lgpl.html
 * -------------------------------------------------
 */
public class UIFilter implements Filter
{
    public static final Logger log = Logger.getLogger(UIFilter.class);

    public static final boolean INFO = log.isInfoEnabled();
    public static final boolean DEBUG = log.isDebugEnabled();

    public static final String NOT_AUTHORIZED = "You are not authorized for this action.";
    public static final String NO_SESSION = "No user is currently registered for this session";

    protected static String filterName = UIFilter.class.getSimpleName();

    private String errorPage;

    public void init(FilterConfig fConfig) throws ServletException
    {
        if(INFO)
        {
            log.info("Initializing " + filterName);
        }

        if(fConfig != null)
        {
            errorPage = fConfig.getInitParameter("error_page");
        }
        else
        {
            throw new ServletException("Filter failed to load configuration");
        }

        if(INFO)
        {
            log.info("Finished Loading Filter " + filterName);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException
    {
        if(DEBUG)
        {
            log.debug(filterName + " doFilter(...)");
        }

        try
        {
            HttpSession session = ((HttpServletRequest) request).getSession(false);

            if(session != null && session.getAttribute(MVC.Session.eCommonsID.name()) != null)
            {
                chain.doFilter(request, response);
            }
            else
            {
                returnError(request, response, NO_SESSION);
            }
        }
        catch(Exception e)
        {
            log.error("Failed to fulfill request for protected resource", e);
        }
    }

    protected void returnError(ServletRequest request, ServletResponse response, String errorString) throws ServletException, IOException
    {
        String URI = ((HttpServletRequest) request).getRequestURI();
        log.error("prohibiting access to a protected resource:" + URI);

        request.setAttribute("error", errorString);
        request.getRequestDispatcher(errorPage).forward(request, response);
    }


    public void destroy()
    {
        if(INFO)
        {
            log.info("destroy()" + filterName);
        }
    }

}
