package net.shrine.sheriff.model;

import org.apache.log4j.Logger;
import org.hibernate.Session;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@Entity
public class ProtocolNumberCounter
{

    private static final Logger log = Logger.getLogger(ProtocolNumberCounter.class);

    @Id
    private int year;

    @Column(nullable = false)
    private int last;

    public static int getLast(Session session, int year)
    {
        final String selectSQL = "SELECT last FROM ProtocolNumberCounter WHERE year = '"
                + year + "';";
        int ret = -1;
        Statement s = null;
        try
        {
            Connection jdbcConnection = session.connection();
            s = jdbcConnection.createStatement();
            s.execute(selectSQL);
            if(s.getResultSet().first())
            {
                ret = s.getResultSet().getInt("last");
            }
        }
        catch(SQLException ex)
        {
            ex.printStackTrace();
            log.error(ex);
        }
        return ret;
    }

    /**
     * Drop to JDBC to atomically increment and make available for return the next protocol
     * number value for a givern year. I believe that the SQL (LOCK TABLE syntax) is MYSQL
     * specific.
     *
     * @param session
     * @param year
     * @return the value incremented by this connection
     */
    public static int getNext(Session session, int year)
    {
        final String lockSQL = "LOCK TABLES ProtocolNumberCounter WRITE;";
        final String unlockSQL = "UNLOCK TABLES;";
        final String updateSQL = "UPDATE ProtocolNumberCounter SET last = LAST_INSERT_ID(last+1) WHERE year = '"
                + year + "';";
        final String insertSQL = "INSERT INTO ProtocolNumberCounter(year,last) VALUES('"
                + year + "', '0');";
        final String selectSQL = "SELECT last FROM ProtocolNumberCounter WHERE year = '"
                + year + "';";
        int ret = -1;
        Statement s = null;
        try
        {
            Connection jdbcConnection = session.connection();
            s = jdbcConnection.createStatement();

            s.execute(lockSQL);
            s.execute(updateSQL);
            if(s.getUpdateCount() == 0)
            {
                s.execute(insertSQL);
            }
//			s.execute(selectSQL);
//			if (s.getResultSet().first()) {
//				ret = s.getResultSet().getInt("last");
//			}
            ret = getLast(session, year);
        }
        catch(SQLException ex)
        {
            ex.printStackTrace();
            log.error(ex);
        }
        finally
        {
            try
            {
                s.execute(unlockSQL);
            }
            catch(SQLException sqle2)
            {
                ;
            }
        }
        return ret;
    }

    @Override
    public String toString()
    {
        return "ProtocolNumberCounter [year=" + year + ", last=" + last + "]";
    }

}
