package net.shrine.sheriff.model;

import org.spin.tools.Util;

import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

/**
 * [ SUMMARY ]
 * <p/>
 * [ Author ]
 * Andrew McMurry
 * Date: Jul 18, 2009
 * <p/>
 * Harvard Medical School Center for BioMedical Informatics
 *
 * @link http://cbmi.med.harvard.edu
 * <p/>
 * [ In partnership with ]
 * @link http://chip.org
 * @link http://lcs.mgh.harvard.edu
 * @link http://www.brighamandwomens.org
 * @link http://bidmc.harvard.edu
 * @link http://dfhcc.harvard.edu
 * @link http://spin.nci.nih.gov/
 * <p/>
 * <p/>
 * -------------------------------------------------
 * [ Licensing ]
 * All works licensed by the Lesser GPL
 * @link http://www.gnu.org/licenses/lgpl.html
 * -------------------------------------------------
 */
@XmlRootElement
public class SheriffEntryList
{
    public List<SheriffEntry> sheriffEntry = Util.makeArrayList();

    public SheriffEntryList()
    {
    }

    public SheriffEntryList(SheriffEntry sheriffEntry)
    {
        this.sheriffEntry.add(sheriffEntry);
    }

    public SheriffEntryList(List<SheriffEntry> sheriffEntry)
    {
        this.sheriffEntry = sheriffEntry;
    }
}
