package net.shrine.sheriff.model;

import org.spin.tools.StringTools;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Andrew McMurry
 */
@XmlRootElement
@Entity
public class SheriffUser implements Serializable
{
    /**
     * 30000 chars should hopefully be enough in all cases, but not big enough
     * To push us into LONG VARCHAR territory.
     */
    protected static final int maxStringColumnLength = 30000;

    @Id
    private String eCommonsID;

    @Column(nullable = true, length = maxStringColumnLength)
    private String institution;

    @Column(nullable = false)
    @Temporal(TemporalType.TIMESTAMP)
    private Date licenseAgreementTimestamp;

    public String getECommonsID()
    {
        return eCommonsID;
    }

    public void setECommonsID(String eCommonsID)
    {
        this.eCommonsID = eCommonsID;
    }

    public Date getLicenseAgreementTimestamp()
    {
        return licenseAgreementTimestamp;
    }

    public void setLicenseAgreementTimestamp(Date licenseAgreementTimestamp)
    {
        this.licenseAgreementTimestamp = licenseAgreementTimestamp;
    }

    public String getInstitution()
    {
        return institution;
    }

    public void setInstitution(String institution)
    {
        this.institution = institution;
    }

    //
    //NB: Hibernate requires that the semantics of hashCode() and equals()
    //be based on the columns that are annotated with @Id, not every field in the
    //class. -Clint

    public boolean deepEquals(final SheriffUser that)
    {
        if(this == that)
        {
            return true;
        }

        if(that == null || getClass() != that.getClass())
        {
            return false;
        }

        if(eCommonsID != null ? !eCommonsID.equals(that.eCommonsID) : that.eCommonsID != null)
        {
            return false;
        }

        if(institution != null ? !institution.equals(that.institution) : that.institution != null)
        {
            return false;
        }

        if(licenseAgreementTimestamp != null ? !licenseAgreementTimestamp.equals(that.licenseAgreementTimestamp) : that.licenseAgreementTimestamp != null)
        {
            return false;
        }

        return true;
    }

    /**
     * Based on ID, because that is the only field with an @@Id annotation
     */
    @Override
    public int hashCode()
    {
        final int prime = 31;

        int result = 1;

        result = prime * result + (eCommonsID == null ? 0 : eCommonsID.hashCode());

        return result;
    }

    /**
     * Based on ID, because that is the only field with an @@Id annotation
     */
    @Override
    public boolean equals(final Object obj)
    {
        if(this == obj)
        {
            return true;
        }

        if(obj == null)
        {
            return false;
        }

        if(getClass() != obj.getClass())
        {
            return false;
        }

        final SheriffUser other = (SheriffUser) obj;

        if(eCommonsID == null)
        {
            if(other.eCommonsID != null)
            {
                return false;
            }
        }
        else if(!eCommonsID.equals(other.eCommonsID))
        {
            return false;
        }


        return true;
    }

    @Override
    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        //
        sb.append("ecommonsID=" + this.getECommonsID());
        sb.append(StringTools.crlf());
        sb.append("Institution=" + this.getInstitution());
        sb.append(StringTools.crlf());
        sb.append("LicenseAgreementTimestamp=" + this.getLicenseAgreementTimestamp().toString());
        sb.append(StringTools.crlf());

        //
        return sb.toString();
    }
}