package net.shrine.sheriff.view;

import net.shrine.sheriff.controller.AuthFacade;
import net.shrine.sheriff.model.SheriffEntry;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MVC
{
    private static final Logger log = Logger.getLogger(MVC.class);

    public enum Session
    {
        eCommonsID,
        entry,
        entries,
        isAdmin
    }

    public enum Action
    {
        home,
        login,
        logout,
        create,
        read,
        update,
        delete,
        retract,
        resubmit
    }

    public enum Form
    {
        eCommonsID,
        password,
        queryTopicID,
        approval,
        queryName,
        queryIntent,
        note,
        sortBY,
        sortASC,
        followUp,
        queryReason,
        queryReasonOther,
        hasNonShrineCollaborator,
        nonShrineCollaboratorInfo,
        email
    }

    public static Action getAction(HttpServletRequest request)
    {
        try
        {
            return Action.valueOf(request.getParameter("action"));
        }
        catch(Exception e)
        {
            return MVC.Action.home;
        }
    }

    public static String nextUserJsp(Action action)
    {
        return "jsp/user.jsp?action=" + action.name();
    }

    public static String nextAdminJsp(Action action)
    {
        return "jsp/admin.jsp?action=" + action.name();
    }

    public static String nextDetailJsp(Action action)
    {
        return "/jsp/detail.jsp?action=" + action.name();
    }

    public static String nextUserDetailJsp(Action action)
    {
        return "/jsp/user_detail.jsp?action=" + action.name();
    }

    ///---

    public static String getUserActionServlet(Action action, Long queryTopicID)
    {
        return "user?action=" + action.name() + "&" + MVC.Form.queryTopicID + "=" + queryTopicID.toString();
    }

    protected static final String PROFILES_URL = "http://connects.catalyst.harvard.edu/PROFILES/ProfileDetails.aspx?Person=";

    public static String getAdminQueryTopicDetail(Long queryTopicID)
    {
        return "admin?action=" + MVC.Action.read.name() + "&" + MVC.Form.queryTopicID + "=" + queryTopicID.toString();
    }

    public static String getAdminSortedList(MVC.Form sortBY, boolean sortAsc)
    {
        return "admin?action=" + MVC.Action.home.name() + "&" + MVC.Form.sortBY + "=" + sortBY + "&" + MVC.Form.sortASC + "=" + (sortAsc ? "true" : "false");
    }


    public static String getProfileDetailsURL(String eCommonsID)
    {
        return PROFILES_URL + eCommonsID;
    }

    public static String getFormattedDate(Date d)
    {

        SimpleDateFormat fmt = new SimpleDateFormat("MMM dd yyyy");
        return fmt.format(d);
    }

    public static String getEntryDisplayName(SheriffEntry entry)
    {
        return entry.getQueryName() + ((entry.getParentId() != null) ? " (Resubmitted)" : "");

    }
    public static String getQueryReasonDisplay(SheriffEntry entry)
    {
        if(String.valueOf(entry.getQueryReason()).equalsIgnoreCase("Other"))
        {
            return entry.getQueryReasonOther();
        }
        else
        {
            return entry.getQueryReason();
        }
    }

    public static String getEmailDisplay(SheriffEntry entry)
    {
        String email = entry.getEmail();

        if((email != null) && (email.trim().length() > 0))
        {
            return email;
        }
        else
        {
            return "None";
        }
    }

    public static String getEcommonsEmailDisplay(SheriffEntry entry)
    {
        String ecommonsID = entry.getECommonsID();
        String ecommonsEmail = "None";

        try
        {
            ecommonsEmail = AuthFacade.getInstance().getEmailAddress(ecommonsID);
        }
        catch(Exception e)
        {
            log.error("Failed to get eCommons Email", e);
        }
        return ecommonsEmail;
    }

    public static String getNonShrineCollaboratorInfoDisplay(SheriffEntry entry)
    {
        if(entry.getHasNonShrineCollaborator())
        {
            return entry.getNonShrineCollaboratorInfo();
        }
        else
        {
            return "None";
        }
    }

    @SuppressWarnings("unchecked")
    public static List<SheriffEntry> getEntries(HttpSession session)
    {
        List<SheriffEntry> entries = (List<SheriffEntry>) session.getAttribute(Session.entries.name());
        if(null == entries)
        {
            entries = new ArrayList<SheriffEntry>(0);
        }

        return entries;

    }

}
