package net.shrine.util;

import org.apache.log4j.Logger;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;

/**
 * [ Summary ]
 * -------------------------------------------------
 * [ Author ]
 * <p/>
 * This class resolves the various possible hosts that the PSL application may be deployed to, to the various
 * hosts that serve up the centrally shared Catalyst resources.
 *
 * @author Greg Polumbo
 *         Date: Oct 23, 2008
 *         Center for Biomedical Informatics
 *         Harvard Medical School
 *         Childrens Hospital Informatics Program at the
 *         Harvard-MIT division of Health Sciences Technology
 * @link http://cbmi.med.harvard.edu
 * @link http://www.chip.org
 * -------------------------------------------------
 * [ Licensing ]
 * All works licensed by the Lesser GPL
 * @link http://www.gnu.org/licenses/lgpl.html
 * -------------------------------------------------
 * [ Acknowledgement ]
 * Portions of this code donated by Ana Holzbach, David Berkowicz, Henry Chueh and the MGH Lab of Computer Science
 * @link http://www.lcs.mgh.harvard.edu/
 */
public class HostNameResolver
{
    private static final Logger log = Logger.getLogger(HostNameResolver.class);

    private static final String DEFAULT_CENTRAL_HOST_KEY = "DEFAULT_CENTRAL_HOST";

    private static final String DEFAULT_CENTRAL_HOST_NAME = "staging.catalyst.harvard.edu";
    private static final String HOSTNAMES_FILE = "hostnames.properties";

    /**
     * Resolves Host names for the vhosts that house the centrally shared assets that include but are not limited to:
     * header_footer.css - css for the catalyst header and footer
     * external.css - css for weymouth delivered catalyst styled content
     * header.txt - properly formatted xhtml header div common to all catalyst assets
     * footer.txt - properly formatted xhtml footer div common to all catalyst assets
     * <p/>
     * hostname.properties contains a map of PSL host names to central asset host names.
     */
    public static String resolveForHost(final String pslHostName)
    {
        Properties hosts = new Properties();

        try
        {
            URL hostNamesURL = HostNameResolver.class.getClassLoader().getResource(HOSTNAMES_FILE);
            hosts.load(new FileInputStream(new File(hostNamesURL.toURI())));
        }
        catch(Exception e)
        {
            log.error("Failed to find " + HOSTNAMES_FILE + ".  Getting central resources from default host: " + DEFAULT_CENTRAL_HOST_NAME, e);
        }

        if(!hosts.isEmpty() && pslHostName != null)
        {
            if(hosts.containsKey(pslHostName))
            {
                return hosts.getProperty(pslHostName);
            }
            else if(hosts.containsKey(DEFAULT_CENTRAL_HOST_KEY))
            {
                return hosts.getProperty(DEFAULT_CENTRAL_HOST_KEY);
            }
        }

        return DEFAULT_CENTRAL_HOST_NAME;
    }
}
