/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.shrine.sheriff.controller.SheriffAuthException;
import net.shrine.sheriff.controller.SheriffDAOException;
import net.shrine.sheriff.model.ApprovalStatus;
import net.shrine.sheriff.model.ProtocolNumberCounter;
import net.shrine.sheriff.model.RoleLevel;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffException;
import net.shrine.sheriff.model.SheriffHibernateUtil;
import net.shrine.sheriff.model.SheriffUser;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class SheriffDAO {
    private static final Logger log = Logger.getLogger(SheriffDAO.class);
    private final boolean DEBUG = log.isDebugEnabled();
    private final boolean INFO = log.isInfoEnabled();
    private static SessionFactory sessionFactory = null;

    public SheriffDAO() {
        if (sessionFactory == null) {
            sessionFactory = SheriffHibernateUtil.Instance.getSessionFactory();
        }
    }

    public SheriffEntry createNewPendingEntry(SheriffEntry source) throws SheriffDAOException, SheriffAuthException {
        String ecommonsID = source.getECommonsID();
        String email = source.getEmail();
        String queryName = source.getQueryName();
        String queryIntent = source.getQueryIntent();
        String queryReason = source.getQueryReason();
        String queryReasonOther = source.getQueryReasonOther();
        boolean hasNonShrineCollaborator = source.getHasNonShrineCollaborator();
        String nonShrineCollaboratorInfo = source.getNonShrineCollaboratorInfo();
        SheriffEntry clone = this.createNewPendingEntry(ecommonsID, email, queryName, queryIntent, queryReason, queryReasonOther, hasNonShrineCollaborator, nonShrineCollaboratorInfo);
        clone.setParentId(source.getQueryTopicID());
        return clone;
    }

    public SheriffEntry createNewPendingEntry(String ecommonsID, String email, String queryName, String queryIntent, String queryReason, String queryReasonOther, boolean hasNonShrineCollaborator, String nonShrineCollaboratorInfo) throws SheriffDAOException, SheriffAuthException {
        SheriffEntry sheriffEntry = null;
        try {
            sheriffEntry = new SheriffEntry();
            sheriffEntry.setECommonsID(ecommonsID);
            sheriffEntry.setEmail(email);
            sheriffEntry.setApproval(ApprovalStatus.Pending);
            sheriffEntry.setRole(RoleLevel.Aggregate);
            sheriffEntry.setQueryName(queryName);
            sheriffEntry.setQueryIntent(queryIntent);
            sheriffEntry.setQueryReason(queryReason);
            sheriffEntry.setQueryReasonOther(queryReasonOther);
            sheriffEntry.setHasNonShrineCollaborator(hasNonShrineCollaborator);
            sheriffEntry.setNonShrineCollaboratorInfo(nonShrineCollaboratorInfo);
            sheriffEntry.setRequestedTimestamp(new Date());
            this.create(sheriffEntry);
        }
        catch (SheriffException e) {
            throw new SheriffDAOException("Failed to write to the sheriff database.", e);
        }
        return sheriffEntry;
    }

    public void create(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)"Creating sheriff entry.");
        }
        Session session = sessionFactory.openSession();
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(entry.getRequestedTimestamp());
            int year = cal.get(1);
            int numberInYear = ProtocolNumberCounter.getNext((org.hibernate.Session)session, year);
            session.beginTransaction();
            entry.setProtocolNumber(year, numberInYear);
            if (this.INFO) {
                log.info((Object)("Saving entry " + String.valueOf(entry)));
            }
            session.save((Object)entry);
            session.getTransaction().commit();
            if (this.DEBUG) {
                log.debug((Object)("Created entry " + entry.getProtocolNumber() + " successfully"));
            }
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new SheriffDAOException("Could not create entry", e);
        }
        catch (Error e) {
            log.error((Object)"Could not create entry: Fatal Error: ", (Throwable)e);
            throw new SheriffDAOException("Holy Fatal error batman!", e);
        }
        finally {
            this.closeSession((org.hibernate.Session)session);
        }
    }

    public List<SheriffEntry> readAll() throws SheriffException {
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        return this.read(clauses);
    }

    public List<SheriffEntry> readPendingEntries() throws SheriffDAOException {
        if (this.DEBUG) {
            log.debug((Object)"readPendingEntries() sheriff entries for all users");
        }
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(QueryParam.APPROVAL.eq(ApprovalStatus.Pending));
        return this.read(clauses);
    }

    public List<SheriffEntry> readByRequestorID(String eCommonsID) throws SheriffException {
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(QueryParam.ECOMMONSID.eq(eCommonsID));
        return this.read(clauses);
    }

    public List<SheriffEntry> readApprovedEntries(String eCommonsID) throws SheriffDAOException {
        if (this.DEBUG) {
            log.debug((Object)("readApprovedEntries() sheriff entries for user " + eCommonsID));
        }
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(QueryParam.ECOMMONSID.eq(eCommonsID));
        clauses.add(QueryParam.APPROVAL.eq(ApprovalStatus.Approved));
        return this.read(clauses);
    }

    public List<SheriffEntry> readPendingEntries(String eCommonsID) throws SheriffDAOException {
        if (this.DEBUG) {
            log.debug((Object)("readPendingEntries() sheriff entries for user " + eCommonsID));
        }
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(QueryParam.ECOMMONSID.eq(eCommonsID));
        clauses.add(QueryParam.APPROVAL.eq(ApprovalStatus.Pending));
        return this.read(clauses);
    }

    public SheriffEntry readById(Long queryTopicID) throws SheriffDAOException {
        if (this.DEBUG) {
            log.debug((Object)("readById() for query topic id " + queryTopicID));
        }
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(QueryParam.QUERYTOPICID.eq(queryTopicID));
        return this.read(clauses).get(0);
    }

    public List<SheriffEntry> read(List<Criterion> clauses) throws SheriffDAOException {
        return this.read(clauses, QueryParam.REQUESTEDTIMESTAMP.descending());
    }

    public List<SheriffEntry> read(List<Criterion> clauses, Order ... sortCriteria) throws SheriffDAOException {
        Session session;
        block10: {
            session = null;
            if (this.DEBUG) {
                StringBuilder queryDescription = new StringBuilder("Read: Criteria[");
                for (Criterion clause : clauses) {
                    queryDescription.append("{").append(clause.toString()).append("}");
                }
                queryDescription.append("], Order[");
                for (Order order : sortCriteria) {
                    queryDescription.append("{").append(order.toString()).append("}");
                }
                queryDescription.append("]");
                log.debug((Object)queryDescription.toString());
            }
            session = sessionFactory.openSession();
            Criteria criteria = session.createCriteria(SheriffEntry.class);
            for (Criterion clause : clauses) {
                criteria.add(clause);
            }
            criteria.add(QueryParam.APPROVAL.ne(ApprovalStatus.Deleted));
            for (Order o : sortCriteria) {
                criteria.addOrder(o);
            }
            List results = criteria.list();
            if (results == null) break block10;
            List list = results;
            this.closeSession((org.hibernate.Session)session);
            return list;
        }
        try {
            ArrayList<SheriffEntry> arrayList = new ArrayList<SheriffEntry>();
            this.closeSession((org.hibernate.Session)session);
            return arrayList;
        }
        catch (Exception e) {
            try {
                log.error((Object)"Failed to read entries.", (Throwable)e);
                throw new SheriffDAOException("Failed to read entries.", e);
            }
            catch (Throwable throwable) {
                this.closeSession((org.hibernate.Session)session);
                throw throwable;
            }
        }
    }

    public void update(Long queryTopicID, ApprovalStatus approval) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("update() queryTopicID " + queryTopicID + " status " + approval.name()));
        }
        try {
            SheriffEntry entry = this.readById(queryTopicID);
            entry.setApproval(approval);
            entry.setApprovalTimestamp(new Date());
            this.update(entry);
        }
        catch (Exception e) {
            log.error((Object)"Failed to read entries.", (Throwable)e);
            throw new SheriffException("Failed to set approval status to " + approval.toString() + " for query topic " + queryTopicID);
        }
    }

    public void delete(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("delete() queryTopicID " + entry.getProtocolNumber() + " status " + entry.getApproval().name()));
        }
        entry.setApproval(ApprovalStatus.Deleted);
        this.update(entry);
    }

    public void retract(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("retract() queryTopicID " + entry.getProtocolNumber() + " status " + entry.getApproval().name()));
        }
        if (entry.getApproval() != ApprovalStatus.Pending) {
            SheriffException e = new SheriffException("Failed to retract request. Current approval state is: \"" + entry.getApproval().name() + "\"");
            log.error((Object)e);
            throw e;
        }
        entry.setApproval(ApprovalStatus.Retracted);
        this.update(entry);
    }

    public void resubmit(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("resubmit() queryTopicID " + entry.getProtocolNumber() + " status " + entry.getApproval().name()));
        }
        if (entry.getApproval() != ApprovalStatus.Denied && entry.getApproval() != ApprovalStatus.Retracted) {
            SheriffException e = new SheriffException("Failed to re-submit request. Current approval state is: \"" + entry.getApproval().name() + "\"");
            log.error((Object)e);
            throw e;
        }
        SheriffEntry clone = this.createNewPendingEntry(entry);
        this.update(clone);
    }

    public void update(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("update() called " + entry));
        }
        Session session = null;
        try {
            session = sessionFactory.openSession();
            session.beginTransaction();
            session.update((Object)entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new SheriffException("Could not update entry", (Throwable)e);
        }
        finally {
            this.closeSession((org.hibernate.Session)session);
        }
    }

    public SheriffUser readUser(String ecommonsID) throws SheriffDAOException {
        Session session = null;
        try {
            session = sessionFactory.openSession();
            Criteria criteria = session.createCriteria(SheriffUser.class);
            criteria.add((Criterion)Restrictions.eq((String)"eCommonsID", (Object)ecommonsID));
            List results = criteria.list();
            SheriffUser sheriffUser = results.size() == 1 ? (SheriffUser)results.get(0) : null;
            return sheriffUser;
        }
        catch (Exception e) {
            throw new SheriffDAOException(e);
        }
        finally {
            this.closeSession((org.hibernate.Session)session);
        }
    }

    private void closeSession(org.hibernate.Session session) {
        try {
            session.close();
        }
        catch (Exception e) {
            log.error((Object)"Error while closing session", (Throwable)e);
        }
    }

    private void destroy(SheriffEntry entry) throws SheriffException {
        if (this.DEBUG) {
            log.debug((Object)("delete() called " + entry));
        }
        Session session = sessionFactory.openSession();
        try {
            session.beginTransaction();
            session.delete((Object)entry);
            session.getTransaction().commit();
        }
        catch (RuntimeException e) {
            session.getTransaction().rollback();
            throw new SheriffDAOException("Could not remove", e);
        }
        finally {
            this.closeSession((org.hibernate.Session)session);
        }
    }

    public void truncateSheriffEntries() throws Exception {
        log.warn((Object)"Truncating SheriffEntry table");
        for (SheriffEntry entry : this.readAll()) {
            this.destroy(entry);
        }
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static enum QueryParam {
        QUERYTOPICID("queryTopicID"),
        ROLE("role"),
        ECOMMONSID("eCommonsID"),
        QUERYNAME("queryName"),
        QUERYINTENT("queryIntent"),
        APPROVAL("approval"),
        REQUESTEDTIMESTAMP("requestedTimestamp"),
        APPROVALTIMESTAMP("approvalTimestamp"),
        NOTE("note"),
        PROTOCOLNUMBER("protocolNumber");

        private final String property;

        private QueryParam(String propertyName) {
            this.property = propertyName;
        }

        public Criterion eq(Object value) {
            return Restrictions.eq((String)this.property, (Object)value);
        }

        public Criterion ne(Object value) {
            return Restrictions.ne((String)this.property, (Object)value);
        }

        public Criterion like(Object value) {
            return Restrictions.like((String)this.property, (Object)value);
        }

        public Order ascending() {
            return Order.asc((String)this.property);
        }

        public Order descending() {
            return Order.desc((String)this.property);
        }
    }
}

