/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.view;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shrine.sheriff.model.ApprovalStatus;
import net.shrine.sheriff.model.SheriffDAO;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffException;
import net.shrine.sheriff.view.MVC;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;

public class AdminInterfaceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(AdminInterfaceServlet.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final boolean INFO = log.isInfoEnabled();
    private SheriffDAO sheriff;

    public void init() throws ServletException {
        super.init();
        if (INFO) {
            log.info((Object)"Starting up Admin Interface Servlet.");
        }
        if (INFO) {
            log.info((Object)"Getting handle on DAO.");
        }
        this.sheriff = new SheriffDAO();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextURL = null;
        HttpSession session = request.getSession();
        String ecommonsID = request.getParameter(MVC.Form.eCommonsID.name());
        String email = request.getParameter(MVC.Form.email.name());
        String approvalStatus = request.getParameter(MVC.Form.approval.name());
        String queryName = request.getParameter(MVC.Form.queryName.name());
        String queryIntent = request.getParameter(MVC.Form.queryIntent.name());
        String note = request.getParameter(MVC.Form.note.name());
        String sortBY = request.getParameter(MVC.Form.sortBY.name());
        String sortASC = request.getParameter(MVC.Form.sortASC.name());
        String followUp = request.getParameter(MVC.Form.followUp.name());
        String queryReason = request.getParameter(MVC.Form.queryReason.name());
        String queryReasonOther = request.getParameter(MVC.Form.queryReasonOther.name());
        boolean hasNonShrineCollaborator = false;
        String nonShrineCollaboratorVal = request.getParameter(MVC.Form.hasNonShrineCollaborator.name());
        if (null != nonShrineCollaboratorVal) {
            hasNonShrineCollaborator = nonShrineCollaboratorVal.equalsIgnoreCase("y");
        }
        String nonShrineCollaboratorInfo = request.getParameter(MVC.Form.nonShrineCollaboratorInfo.name());
        Long queryTopicID = null;
        if (null != request.getParameter(MVC.Form.queryTopicID.name())) {
            queryTopicID = Long.parseLong(request.getParameter(MVC.Form.queryTopicID.name()));
        }
        if (DEBUG) {
            log.debug((Object)("ecommonsID " + ecommonsID));
            log.debug((Object)("email " + email));
            log.debug((Object)("queryTopicID " + queryTopicID));
            log.debug((Object)("approvalStatus " + approvalStatus));
            log.debug((Object)("queryName " + queryName));
            log.debug((Object)("queryIntent " + queryIntent));
            log.debug((Object)("note " + note));
            log.debug((Object)("sortBy " + sortBY));
            log.debug((Object)("sortASC " + sortASC));
            log.debug((Object)("followUp " + followUp));
            log.debug((Object)("queryReason " + queryReason));
            log.debug((Object)("queryReasonOther " + queryReasonOther));
            log.debug((Object)("hasNonShrineCollaborator " + hasNonShrineCollaborator));
            log.debug((Object)("nonShrineCollaboratorInfo " + nonShrineCollaboratorInfo));
        }
        try {
            switch (MVC.getAction(request)) {
                case create: {
                    SheriffEntry newEntry = this.sheriff.createNewPendingEntry(ecommonsID, email, queryName, queryIntent, queryReason, queryReasonOther, hasNonShrineCollaborator, nonShrineCollaboratorInfo);
                    if (INFO) {
                        log.info((Object)("Created: " + String.valueOf(newEntry)));
                    }
                    this.reCacheEntries(session);
                    nextURL = MVC.nextAdminJsp(MVC.Action.home);
                    break;
                }
                case read: {
                    SheriffEntry entry = this.sheriff.readById(queryTopicID);
                    if (INFO) {
                        log.info((Object)("Read: " + String.valueOf(entry)));
                    }
                    session.setAttribute(MVC.Session.entry.name(), (Object)entry);
                    nextURL = MVC.nextDetailJsp(MVC.Action.home);
                    break;
                }
                case update: {
                    SheriffEntry cached = (SheriffEntry)session.getAttribute(MVC.Session.entry.name());
                    if (cached == null) {
                        log.error((Object)"Cache entry not found! ");
                    } else if (DEBUG) {
                        log.debug((Object)String.valueOf(cached));
                    }
                    if (INFO) {
                        log.info((Object)"Admin changed content of the request, updating now.");
                    }
                    SheriffEntry savedCopy = this.sheriff.readById(queryTopicID);
                    savedCopy.setQueryIntent(queryIntent);
                    savedCopy.setNote(note);
                    savedCopy.setFollowUp(followUp);
                    savedCopy.setQueryName(queryName);
                    this.sheriff.update(savedCopy);
                    if (INFO) {
                        log.info((Object)("Admin Updated: " + String.valueOf(savedCopy)));
                    }
                    if (!approvalStatus.equalsIgnoreCase(cached.getApproval().name())) {
                        if (INFO) {
                            log.info((Object)"Admin changed status of the request, updating now.");
                        }
                        this.sheriff.update(queryTopicID, ApprovalStatus.valueOf((String)approvalStatus));
                    }
                    this.reCacheEntries(session);
                    nextURL = MVC.nextAdminJsp(MVC.Action.home);
                    break;
                }
                case delete: {
                    SheriffEntry toDelete = this.sheriff.readById(queryTopicID);
                    if (INFO) {
                        log.info((Object)("Admin Deleting: " + String.valueOf(toDelete)));
                    }
                    this.sheriff.delete(toDelete);
                    this.reCacheEntries(session);
                }
                default: {
                    if (INFO) {
                        log.info((Object)("User " + ecommonsID + " viewing all open topics"));
                    }
                    boolean ready = false;
                    if (sortBY != null && sortASC != null) {
                        try {
                            this.reCacheEntries(session, sortBY, Boolean.parseBoolean(sortASC));
                            ready = true;
                        }
                        catch (Exception e) {
                            log.error((Object)"Could not parse sortBY and sortASC params, reCacheEntries(session) using defaults.", (Throwable)e);
                        }
                    }
                    if (!ready) {
                        this.reCacheEntries(session);
                    }
                    nextURL = MVC.nextAdminJsp(MVC.Action.home);
                    break;
                }
            }
        }
        catch (SheriffException e) {
            throw new ServletException("Request failed", (Throwable)e);
        }
        request.getRequestDispatcher(nextURL).forward((ServletRequest)request, (ServletResponse)response);
    }

    private void reCacheEntries(HttpSession session) throws SheriffException {
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(SheriffDAO.QueryParam.APPROVAL.ne(ApprovalStatus.Retracted));
        session.setAttribute(MVC.Session.entries.name(), this.sheriff.read(clauses, SheriffDAO.QueryParam.APPROVAL.ascending(), SheriffDAO.QueryParam.REQUESTEDTIMESTAMP.descending()));
    }

    private void reCacheEntries(HttpSession session, String sortBY, boolean sortAsc) throws SheriffException {
        ArrayList<Criterion> clauses = new ArrayList<Criterion>();
        clauses.add(SheriffDAO.QueryParam.APPROVAL.ne(ApprovalStatus.Retracted));
        SheriffDAO.QueryParam sort = null;
        try {
            sort = SheriffDAO.QueryParam.valueOf(sortBY.toUpperCase());
        }
        catch (Exception e) {
            log.error((Object)("Unknown sort criteria: " + String.valueOf((Object)sort)), (Throwable)e);
        }
        if (sort != null) {
            Order sortCriteria = sortAsc ? sort.ascending() : sort.descending();
            session.setAttribute(MVC.Session.entries.name(), this.sheriff.read(clauses, sortCriteria));
        } else {
            this.reCacheEntries(session);
        }
    }
}

