/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.controller;

import edu.harvard.med.cbmi.auth.Ecauthnport;
import edu.harvard.med.cbmi.auth.Ecauthnsvc;
import java.util.List;
import net.shrine.serializers.HTTPClient;
import org.apache.log4j.Logger;
import org.spin.extension.JDOMTool;
import org.spin.query.message.identity.IdentityServiceException;

public class AuthFacade {
    private static final Logger log = Logger.getLogger(AuthFacade.class);
    private static AuthFacade instance;
    private final String application;
    private final String issuer;
    private final String profilesURL;
    private final Ecauthnsvc service;
    private final Ecauthnport port;
    public static final String PROFILES_REQUEST = "<Profiles Operation=\"GetPersonList\" xmlns=\"http://connects.profiles.schema/profiles/query\"><QueryDefinition><PersonID>%s</PersonID></QueryDefinition>  <OutputOptions SortType=\"LastFirstName\" StartRecord=\"1\" MaxRecords=\"1\" /></Profiles>";
    public static final String PROFILES_NAMESPACE = "xmlns=\"http://connects.profiles.schema/profiles/personlist\"";

    public static AuthFacade createInstance(String application, String issuer, String profilesURL) {
        instance = new AuthFacade(application, issuer, profilesURL);
        return instance;
    }

    public static AuthFacade getInstance() {
        return instance;
    }

    private AuthFacade(String application, String issuer, String profilesURL) {
        this.application = application;
        this.issuer = issuer;
        this.profilesURL = profilesURL;
        this.service = new Ecauthnsvc();
        this.port = this.service.getEcauthnport();
    }

    public boolean authenticateEcommons(String eCommonsID, String eCommonsPWD) throws IdentityServiceException {
        return this.port.authenticate(this.application, this.issuer, eCommonsID, eCommonsPWD);
    }

    public boolean authorizeFacultyStatus(String eCommonsID) throws IdentityServiceException {
        return this.authorizeFacultyStatus(eCommonsID, this.profilesURL);
    }

    public boolean authorizeFacultyStatus(String eCommonsID, String url) throws IdentityServiceException {
        boolean isApproved = false;
        try {
            String requestXML = String.format(PROFILES_REQUEST, eCommonsID);
            log.debug((Object)("authorizeFacultyStatus() posting to " + url + " " + requestXML));
            String responseXML = HTTPClient.post((String)requestXML, (String)url);
            log.debug((Object)("authorizeFacultyStatus() returns: " + responseXML));
            responseXML = responseXML.replaceFirst(PROFILES_NAMESPACE, "");
            JDOMTool jdom = new JDOMTool(responseXML);
            List facultyTypes = jdom.getElementValues("//FacultyType");
            if (facultyTypes != null) {
                log.debug((Object)("FacultyStatus found , count=" + facultyTypes.size()));
                for (String facultyType : facultyTypes) {
                    log.debug((Object)("//FacultyType " + facultyType));
                    if (facultyType.toUpperCase().contains("FACULTY")) {
                        isApproved = true;
                    }
                    if (facultyType.toUpperCase().contains("PROFESSOR")) {
                        isApproved = true;
                    }
                    if (!facultyType.toUpperCase().contains("INSTRUCTOR")) continue;
                    isApproved = true;
                }
            }
        }
        catch (Exception e) {
            throw new IdentityServiceException("failed to authorize faculty status", (Throwable)e);
        }
        return isApproved;
    }

    public String getEmailAddress(String ecommonsID) {
        return this.port.getEmail(this.issuer, ecommonsID);
    }

    public String getName(String ecommonsID) {
        return this.port.getName(this.issuer, ecommonsID);
    }
}

