/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.controller;

import javax.mail.MessagingException;
import net.shrine.sheriff.controller.AuthFacade;
import org.apache.log4j.Logger;
import org.spin.extension.MailTool;
import org.spin.tools.config.ConfigException;

public class SheriffMailUtil {
    private static SheriffMailUtil instance = null;
    protected static final Logger log = Logger.getLogger(SheriffMailUtil.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    private MailTool mailTool = null;
    private boolean sendEmailNotifications;
    private String dataStewardEmail;
    private AuthFacade authFacade;

    private SheriffMailUtil(boolean sendEmailNotifications, String dataStewardEmail, AuthFacade authFacade) {
        if (INFO) {
            log.info((Object)"Initializing SheriffMailUtil...");
        }
        this.sendEmailNotifications = sendEmailNotifications;
        this.dataStewardEmail = dataStewardEmail;
        if (this.isSendEmailNotifications()) {
            try {
                this.mailTool = MailTool.getInstance();
            }
            catch (ConfigException cfe) {
                this.mailTool = null;
                this.setSendEmailNotifications(false);
                log.error((Object)"Failed to initialize mailTool, setting SEND_EMAIL_NOTIFICATIONS to FALSE.", (Throwable)cfe);
            }
        }
    }

    public static SheriffMailUtil createInstance(boolean sendEmail, String dataStewardEmail) {
        AuthFacade authFacade = AuthFacade.getInstance();
        if (authFacade == null) {
            throw new Error("AuthFacade is not initialized.");
        }
        instance = new SheriffMailUtil(sendEmail, dataStewardEmail, authFacade);
        return instance;
    }

    public static SheriffMailUtil getInstance() {
        return instance;
    }

    protected String getDataStewardEmail() {
        return this.dataStewardEmail;
    }

    public boolean isSendEmailNotifications() {
        return this.sendEmailNotifications;
    }

    protected void setSendEmailNotifications(boolean b) {
        this.sendEmailNotifications = false;
    }

    public void sendSysAdminNotification(String subject, String message) {
        try {
            if (this.isSendEmailNotifications()) {
                if (INFO) {
                    log.info((Object)("Sending sendSysAdminNotification: \"" + subject + "\", SendEmailNotifications=" + this.isSendEmailNotifications()));
                }
                this.mailTool.sendAdminNotification(subject, message);
            } else if (INFO) {
                log.info((Object)("NOT sending sendSysAdminNotification: \"" + subject + "\", SendEmailNotifications=" + this.isSendEmailNotifications()));
            }
        }
        catch (MessagingException e) {
            log.error((Object)"Failed to send notification to system administrator.", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void sendDataStewardNotification(String subject, String message) {
        try {
            if (this.isSendEmailNotifications()) {
                if (INFO) {
                    log.info((Object)("Sending Data Steward notification: \"" + subject + "\", SendEmailNotifications=" + this.isSendEmailNotifications()));
                }
                this.mailTool.sendMail(this.getSender(), this.getDataStewardEmail(), subject, message);
            } else if (INFO) {
                log.info((Object)("NOT sending Data Steward notification: \"" + subject + "\", SendEmailNotifications=" + this.isSendEmailNotifications()));
            }
        }
        catch (MessagingException e) {
            log.error((Object)"Failed to send notification to Data Steward.", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void sendUserNotification(String ecommonsID, String subject, String message) {
        try {
            if (this.isSendEmailNotifications()) {
                String email = this.authFacade.getEmailAddress(ecommonsID);
                if (INFO) {
                    log.info((Object)("Sending user notification: \"" + subject + "\" to user:" + ecommonsID + " (" + email + "), SendEmailNotifications=" + this.isSendEmailNotifications()));
                }
                this.mailTool.sendMail(this.getSender(), email, subject, message);
            } else if (INFO) {
                log.info((Object)("NOT sending user notification: \"" + subject + "\" to user:" + ecommonsID + ", SendEmailNotifications=" + this.isSendEmailNotifications()));
            }
        }
        catch (MessagingException e) {
            log.error((Object)("Failed to send notification to user: " + String.valueOf(ecommonsID)), (Throwable)e);
            e.printStackTrace();
        }
    }

    private String getSender() {
        return this.mailTool.getMailToolConfig().getSender();
    }
}

