/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.shrine.sheriff.controller.AuthFacade;
import net.shrine.sheriff.model.SheriffEntry;
import org.apache.log4j.Logger;

public class MVC {
    private static final Logger log = Logger.getLogger(MVC.class);
    protected static final String PROFILES_URL = "http://connects.catalyst.harvard.edu/PROFILES/ProfileDetails.aspx?Person=";

    public static Action getAction(HttpServletRequest request) {
        try {
            return Action.valueOf(request.getParameter("action"));
        }
        catch (Exception e) {
            return Action.home;
        }
    }

    public static String nextUserJsp(Action action) {
        return "jsp/user.jsp?action=" + action.name();
    }

    public static String nextAdminJsp(Action action) {
        return "jsp/admin.jsp?action=" + action.name();
    }

    public static String nextDetailJsp(Action action) {
        return "/jsp/detail.jsp?action=" + action.name();
    }

    public static String nextUserDetailJsp(Action action) {
        return "/jsp/user_detail.jsp?action=" + action.name();
    }

    public static String getUserActionServlet(Action action, Long queryTopicID) {
        return "user?action=" + action.name() + "&" + (Object)((Object)Form.queryTopicID) + "=" + queryTopicID.toString();
    }

    public static String getAdminQueryTopicDetail(Long queryTopicID) {
        return "admin?action=" + Action.read.name() + "&" + (Object)((Object)Form.queryTopicID) + "=" + queryTopicID.toString();
    }

    public static String getAdminSortedList(Form sortBY, boolean sortAsc) {
        return "admin?action=" + Action.home.name() + "&" + (Object)((Object)Form.sortBY) + "=" + (Object)((Object)sortBY) + "&" + (Object)((Object)Form.sortASC) + "=" + (sortAsc ? "true" : "false");
    }

    public static String getProfileDetailsURL(String eCommonsID) {
        return PROFILES_URL + eCommonsID;
    }

    public static String getFormattedDate(Date d) {
        SimpleDateFormat fmt = new SimpleDateFormat("MMM dd yyyy");
        return fmt.format(d);
    }

    public static String getEntryDisplayName(SheriffEntry entry) {
        return entry.getQueryName() + (entry.getParentId() != null ? " (Resubmitted)" : "");
    }

    public static String getQueryReasonDisplay(SheriffEntry entry) {
        if (String.valueOf(entry.getQueryReason()).equalsIgnoreCase("Other")) {
            return entry.getQueryReasonOther();
        }
        return entry.getQueryReason();
    }

    public static String getEmailDisplay(SheriffEntry entry) {
        String email = entry.getEmail();
        if (email != null && email.trim().length() > 0) {
            return email;
        }
        return "None";
    }

    public static String getEcommonsEmailDisplay(SheriffEntry entry) {
        String ecommonsID = entry.getECommonsID();
        String ecommonsEmail = "None";
        try {
            ecommonsEmail = AuthFacade.getInstance().getEmailAddress(ecommonsID);
        }
        catch (Exception e) {
            log.error((Object)"Failed to get eCommons Email", (Throwable)e);
        }
        return ecommonsEmail;
    }

    public static String getNonShrineCollaboratorInfoDisplay(SheriffEntry entry) {
        if (entry.getHasNonShrineCollaborator()) {
            return entry.getNonShrineCollaboratorInfo();
        }
        return "None";
    }

    public static List<SheriffEntry> getEntries(HttpSession session) {
        ArrayList entries = (ArrayList)session.getAttribute(Session.entries.name());
        if (null == entries) {
            entries = new ArrayList(0);
        }
        return entries;
    }

    public static enum Form {
        eCommonsID,
        password,
        queryTopicID,
        approval,
        queryName,
        queryIntent,
        note,
        sortBY,
        sortASC,
        followUp,
        queryReason,
        queryReasonOther,
        hasNonShrineCollaborator,
        nonShrineCollaboratorInfo,
        email;

    }

    public static enum Action {
        home,
        login,
        logout,
        create,
        read,
        update,
        delete,
        retract,
        resubmit;

    }

    public static enum Session {
        eCommonsID,
        entry,
        entries,
        isAdmin;

    }
}

