/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.controller;

import java.util.List;
import javax.jws.WebService;
import javax.xml.crypto.dsig.XMLSignatureException;
import net.shrine.sheriff.model.ApprovalStatus;
import net.shrine.sheriff.model.Sheriff;
import net.shrine.sheriff.model.SheriffDAO;
import net.shrine.sheriff.model.SheriffEntry;
import net.shrine.sheriff.model.SheriffException;
import org.apache.log4j.Logger;
import org.spin.tools.crypto.signature.Identity;
import org.spin.tools.crypto.signature.Signable;
import org.spin.tools.crypto.signature.XMLSignatureUtil;

@WebService(serviceName="Sheriff", portName="SheriffPort", targetNamespace="http://net.shrine.sheriff.controller", endpointInterface="net.shrine.sheriff.model.Sheriff")
public class SheriffImpl
implements Sheriff {
    protected final Logger log = Logger.getLogger(SheriffImpl.class);
    protected final boolean DEBUG = this.log.isDebugEnabled();
    protected final boolean INFO = this.log.isInfoEnabled();
    protected final SheriffDAO dao = new SheriffDAO();

    public SheriffEntry readApprovedTopic(Identity identity, Integer queryTopicID) throws SheriffException {
        SheriffEntry entry;
        String username = this.getUsernameFromIdentity(identity);
        if (this.INFO) {
            this.log.info((Object)("Attempting to validate approved sheriff topic \"" + queryTopicID + "\" for " + username));
        }
        if ((entry = this.dao.readById(new Long(queryTopicID.intValue()))) != null && entry.getECommonsID().equalsIgnoreCase(username) && entry.getApproval() == ApprovalStatus.Approved) {
            if (this.INFO) {
                this.log.info((Object)("QUERY: validated approved sheriff topic \"" + entry.getQueryName() + "\" for " + username));
            }
            return entry;
        }
        throw new SheriffException("Validation FAILED for sheriff topic \"" + queryTopicID + "\" for " + username + ": " + String.valueOf(entry));
    }

    public List<SheriffEntry> readApprovedEntries(Identity identity) throws SheriffException {
        try {
            String username = this.getUsernameFromIdentity(identity);
            if (this.INFO) {
                this.log.info((Object)("Attempting to read approved sheriff entries for " + username));
            }
            List<SheriffEntry> entries = this.dao.readApprovedEntries(identity.getUsername());
            if (this.INFO) {
                this.log.info((Object)("LOGIN: Returning " + entries.size() + " entries for " + username));
            }
            return entries;
        }
        catch (SheriffException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SheriffException("Unhandled exception during readApprovedEntries", (Throwable)e);
        }
    }

    private String getUsernameFromIdentity(Identity identity) throws SheriffException {
        if (identity == null) {
            throw new SheriffException("Identity not provided to read approved query topics.");
        }
        String username = identity.getUsername();
        if (username == null) {
            throw new SheriffException("Username not provided to read approved query topics.");
        }
        try {
            if (!XMLSignatureUtil.verifySignature((Signable)identity)) {
                throw new SheriffException("XML Digital Signature was invalid or untrusted");
            }
        }
        catch (XMLSignatureException e) {
            throw new SheriffException("Error reading signature ", (Throwable)e);
        }
        return username;
    }
}

