/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.model;

import java.net.URL;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.shrine.sheriff.model.ProtocolNumberCounter;
import net.shrine.sheriff.model.SheriffEntry;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.spin.tools.config.ConfigTool;

public class SheriffHibernateUtil {
    private static final Logger log = Logger.getLogger(SheriffHibernateUtil.class);
    private static final boolean INFO = log.isInfoEnabled();
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final String hibernateConfigFileName = "hibernate-sheriff.cfg.xml";
    public static final SheriffHibernateUtil Instance = new SheriffHibernateUtil();
    private final SessionFactory sessionFactory;
    private final String dbDriver;
    private final String dbUrl;
    private final String dataSourceName;

    private SheriffHibernateUtil() {
        this.addShutdownHook();
        try {
            URL configFile = ConfigTool.getConfigFileAsURL((String)hibernateConfigFileName);
            if (DEBUG) {
                log.debug((Object)("Initializing Hibernate with '" + configFile.getFile() + "'"));
            }
            Configuration config = new AnnotationConfiguration().addAnnotatedClass(ProtocolNumberCounter.class).addAnnotatedClass(SheriffEntry.class).configure(configFile);
            this.sessionFactory = config.buildSessionFactory();
            this.dbDriver = config.getProperty("connection.driver_class");
            this.dbUrl = config.getProperty("connection.url");
            this.dataSourceName = config.getProperty("connection.datasource");
        }
        catch (Throwable e) {
            log.error((Object)("Initial SessionFactory creation failed: " + e.getMessage()));
            throw new ExceptionInInitializerError(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SheriffHibernateUtil.this.shutDown();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed shutting down Spin query logging - the Node may take longer to start up next time, or the admin database may be corrupted: ", e);
                }
            }
        }));
    }

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    public final String getDBUrl() {
        return this.dbUrl;
    }

    public final String getDBDriver() {
        return this.dbDriver;
    }

    public final boolean shutDown() {
        this.shutdownHibernate();
        return this.shutdownDerby();
    }

    private boolean shutdownDerby() {
        try {
            Class.forName(this.getDBDriver());
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            log.error((Object)"Failed shutting down Spin admin database");
            return false;
        }
        catch (SQLException e) {
            if (INFO) {
                log.info((Object)"Successfully shut down Spin admin database");
            }
            return true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed shutting down Spin admin database", e);
            return false;
        }
    }

    private void shutdownHibernate() {
        try {
            this.sessionFactory.close();
            if (INFO) {
                log.info((Object)"Shut down Spin Admin Hibernate SessionFactory");
            }
        }
        catch (HibernateException e) {
            log.error((Object)"Error shutting down Spin admin Hibernate SessionFactory");
            throw e;
        }
    }
}

