/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.controller;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.shrine.sheriff.view.MVC;
import org.apache.log4j.Logger;

public class UIFilter
implements Filter {
    public static final Logger log = Logger.getLogger(UIFilter.class);
    public static final boolean INFO = log.isInfoEnabled();
    public static final boolean DEBUG = log.isDebugEnabled();
    public static final String NOT_AUTHORIZED = "You are not authorized for this action.";
    public static final String NO_SESSION = "No user is currently registered for this session";
    protected static String filterName = UIFilter.class.getSimpleName();
    private String errorPage;

    public void init(FilterConfig fConfig) throws ServletException {
        if (INFO) {
            log.info((Object)("Initializing " + filterName));
        }
        if (fConfig == null) {
            throw new ServletException("Filter failed to load configuration");
        }
        this.errorPage = fConfig.getInitParameter("error_page");
        if (INFO) {
            log.info((Object)("Finished Loading Filter " + filterName));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (DEBUG) {
            log.debug((Object)(filterName + " doFilter(...)"));
        }
        try {
            HttpSession session = ((HttpServletRequest)request).getSession(false);
            if (session != null && session.getAttribute(MVC.Session.eCommonsID.name()) != null) {
                chain.doFilter(request, response);
            } else {
                this.returnError(request, response, NO_SESSION);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to fulfill request for protected resource", (Throwable)e);
        }
    }

    protected void returnError(ServletRequest request, ServletResponse response, String errorString) throws ServletException, IOException {
        String URI2 = ((HttpServletRequest)request).getRequestURI();
        log.error((Object)("prohibiting access to a protected resource:" + URI2));
        request.setAttribute("error", (Object)errorString);
        request.getRequestDispatcher(this.errorPage).forward(request, response);
    }

    public void destroy() {
        if (INFO) {
            log.info((Object)("destroy()" + filterName));
        }
    }
}

