/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.sheriff.view;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.shrine.sheriff.controller.AuthFacade;
import net.shrine.sheriff.controller.SheriffMailUtil;
import net.shrine.sheriff.view.MVC;
import org.apache.log4j.Logger;

public class LogonServlet
extends HttpServlet {
    private static final String SEND_EMAIL_NOTIFICATIONS_PARAM = "SEND_EMAIL_NOTIFICATIONS";
    private static final String DATA_STEWARD_USERNAME_PARAM = "DATA_STEWARD_USERNAME";
    private static final String DATA_STEWARD_PASSWORD_PARAM = "DATA_STEWARD_PASSWORD";
    private static final String DATA_STEWARD_EMAIL_PARAM = "DATA_STEWARD_EMAIL";
    private static final String CHECK_FACULTY_PARAM = "CHECK_FACULTY";
    private static final String AUTH_APPLICATION_PARAM = "AUTH_APPLICATION";
    private static final String AUTH_ISSUER_PARAM = "AUTH_ISSUER";
    private static final String AUTH_PROFILES_URL_PARAM = "AUTH_PROFILES_URL";
    private String dataStewardUserName;
    private String dataStewardPassword;
    private boolean checkFaculty;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(LogonServlet.class);

    public void init() throws ServletException {
        super.init();
        this.dataStewardUserName = this.getInitParameter(DATA_STEWARD_USERNAME_PARAM);
        this.dataStewardPassword = this.getInitParameter(DATA_STEWARD_PASSWORD_PARAM);
        try {
            this.checkFaculty = Boolean.parseBoolean(this.getInitParameter(CHECK_FACULTY_PARAM));
            log.info((Object)("CHECK_FACULTY = " + this.checkFaculty));
        }
        catch (Exception e) {
            this.checkFaculty = true;
            log.error((Object)"Failed to parse CHECK_FACULTY, defaulting to TRUE.", (Throwable)e);
        }
        this.initializeAuthentication();
        this.initializeMailConfig();
        if (SheriffMailUtil.getInstance().isSendEmailNotifications()) {
            SheriffMailUtil.getInstance().sendSysAdminNotification("Sheriff application was restarted", DateFormat.getDateTimeInstance(1, 1).format(new Date()));
        }
    }

    private void initializeAuthentication() {
        String application = this.getInitParameter(AUTH_APPLICATION_PARAM);
        String issuer = this.getInitParameter(AUTH_ISSUER_PARAM);
        String profilesURL = this.getInitParameter(AUTH_PROFILES_URL_PARAM);
        log.info((Object)"Initializing Authentication...");
        AuthFacade.createInstance(application, issuer, profilesURL);
    }

    private void initializeMailConfig() {
        boolean sendEmailNotifications;
        log.info((Object)"initializing Mail Config...");
        String dataStewardEmail = this.getInitParameter(DATA_STEWARD_EMAIL_PARAM);
        try {
            sendEmailNotifications = Boolean.parseBoolean(this.getInitParameter(SEND_EMAIL_NOTIFICATIONS_PARAM));
            log.info((Object)("SEND_EMAIL_NOTIFICATIONS = " + sendEmailNotifications));
        }
        catch (Exception e) {
            sendEmailNotifications = false;
            log.error((Object)"Failed to parse SEND_EMAIL_NOTIFICATIONS, defaulting to FALSE.", (Throwable)e);
        }
        SheriffMailUtil.createInstance(sendEmailNotifications, dataStewardEmail);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nextURL = null;
        switch (MVC.getAction(request)) {
            case login: {
                String ecommonsID = request.getParameter(MVC.Form.eCommonsID.name());
                String password = request.getParameter(MVC.Form.password.name());
                if (ecommonsID != null && ecommonsID.equalsIgnoreCase(this.dataStewardUserName)) {
                    if (password != null && password.equals(this.dataStewardPassword)) {
                        HttpSession session = request.getSession(true);
                        session.setAttribute(MVC.Session.isAdmin.name(), (Object)Boolean.TRUE);
                        nextURL = "admin";
                        break;
                    }
                    nextURL = LogonServlet.errorURL("The supplied eCommons username and password were not valid.");
                    break;
                }
                log.info((Object)("Trying to logon user " + ecommonsID));
                boolean authenticated = false;
                boolean authorized = false;
                try {
                    authenticated = AuthFacade.getInstance().authenticateEcommons(ecommonsID, password);
                    authorized = this.checkFaculty ? AuthFacade.getInstance().authorizeFacultyStatus(ecommonsID) : true;
                }
                catch (Exception e) {
                    log.error((Object)"Sheriff offline? ", (Throwable)e);
                    nextURL = LogonServlet.errorURL("Sorry, this application is currently offline.");
                }
                if (!authorized) {
                    nextURL = LogonServlet.errorURL("Sorry, you are not approved Harvard faculty.");
                    break;
                }
                if (!authenticated) {
                    nextURL = LogonServlet.errorURL("The supplied eCommons username and password were not valid.");
                    break;
                }
                HttpSession session = request.getSession(true);
                session.setAttribute(MVC.Session.eCommonsID.name(), (Object)ecommonsID);
                nextURL = "user";
                break;
            }
            case logout: {
                log.info((Object)"Logging out user.");
                request.getSession().invalidate();
            }
            default: {
                nextURL = "jsp/logon.jsp";
            }
        }
        log.debug((Object)("redirecting user to " + nextURL));
        request.getRequestDispatcher(nextURL).forward((ServletRequest)request, (ServletResponse)response);
    }

    private static String errorURL(String error) {
        log.error((Object)error);
        return "jsp/logon.jsp?error=" + error;
    }
}

