/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HostNameResolver {
    private static final Logger log = Logger.getLogger(HostNameResolver.class);
    private static final String DEFAULT_CENTRAL_HOST_KEY = "DEFAULT_CENTRAL_HOST";
    private static final String DEFAULT_CENTRAL_HOST_NAME = "staging.catalyst.harvard.edu";
    private static final String HOSTNAMES_FILE = "hostnames.properties";

    public static String resolveForHost(String pslHostName) {
        Properties hosts = new Properties();
        try {
            URL hostNamesURL = HostNameResolver.class.getClassLoader().getResource(HOSTNAMES_FILE);
            hosts.load(new FileInputStream(new File(hostNamesURL.toURI())));
        }
        catch (Exception e) {
            log.error((Object)"Failed to find hostnames.properties.  Getting central resources from default host: staging.catalyst.harvard.edu", (Throwable)e);
        }
        if (!hosts.isEmpty() && pslHostName != null) {
            if (hosts.containsKey(pslHostName)) {
                return hosts.getProperty(pslHostName);
            }
            if (hosts.containsKey(DEFAULT_CENTRAL_HOST_KEY)) {
                return hosts.getProperty(DEFAULT_CENTRAL_HOST_KEY);
            }
        }
        return DEFAULT_CENTRAL_HOST_NAME;
    }
}

