/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.Enumeration;
import java.util.Iterator;
import org.spin.tools.Util;

public final class IterableEnumeration<T>
implements Iterable<T> {
    private final Enumeration<T> enumeration;

    public IterableEnumeration(Enumeration<T> enumeration) {
        Util.guardNotNull(enumeration);
        this.enumeration = enumeration;
    }

    public static <T> IterableEnumeration<T> from(Enumeration<T> enumeration) {
        return new IterableEnumeration<T>(enumeration);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return IterableEnumeration.this.enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return IterableEnumeration.this.enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

