/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.schema;

import java.util.Locale;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.CheckConstraint;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnMap;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.AnalyzedDatabase;
import schemacrawler.tools.analysis.Lint;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.text.schema.SchemaTextOptions;
import schemacrawler.tools.text.util.TextFormattingHelper;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SchemaTextFormatter
extends BaseFormatter<SchemaTextOptions> {
    private final SchemaTextDetailType schemaTextDetailType;

    private static String negate(boolean positive, String text) {
        String textValue = text;
        if (!positive) {
            textValue = "not " + textValue;
        }
        return textValue;
    }

    SchemaTextFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, schemaTextDetailType == SchemaTextDetailType.verbose_schema, outputOptions);
        this.schemaTextDetailType = schemaTextDetailType;
    }

    private void printCheckConstraints(CheckConstraint[] constraints) {
        for (CheckConstraint constraint : constraints) {
            if (constraint == null) continue;
            String constraintName = "";
            if (!((SchemaTextOptions)this.options).isHideConstraintNames()) {
                constraintName = constraint.getName();
            }
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow(constraintName, "[check constraint]", false));
            String definition = constraint.getDefinition();
            if (Utility.isBlank(definition)) continue;
            this.out.println(this.formattingHelper.createDefinitionRow(definition));
        }
    }

    private void printColumnDataType(ColumnDataType columnDataType) {
        String databaseSpecificTypeName = columnDataType.getFullName();
        String typeName = columnDataType.getTypeName();
        String userDefined = SchemaTextFormatter.negate(columnDataType.isUserDefined(), "user defined");
        String nullable = SchemaTextFormatter.negate(columnDataType.isNullable(), "nullable");
        String autoIncrementable = SchemaTextFormatter.negate(columnDataType.isAutoIncrementable(), "auto-incrementable");
        String definedWith = "defined with ";
        definedWith = columnDataType.getCreateParameters() == null ? definedWith + "no parameters" : definedWith + columnDataType.getCreateParameters();
        this.out.println(this.formattingHelper.createNameRow(databaseSpecificTypeName, "[data type]", false));
        this.out.println(this.formattingHelper.createDetailRow("", "based on", typeName));
        this.out.println(this.formattingHelper.createDefinitionRow(userDefined));
        this.out.println(this.formattingHelper.createDefinitionRow(definedWith));
        this.out.println(this.formattingHelper.createDefinitionRow(nullable));
        this.out.println(this.formattingHelper.createDefinitionRow(autoIncrementable));
        this.out.println(this.formattingHelper.createDefinitionRow(columnDataType.getSearchable().toString()));
    }

    private void printColumnPairs(String tableName, ColumnMap ... columnPairs) {
        for (ColumnMap columnPair : columnPairs) {
            Column pkColumn = columnPair.getPrimaryKeyColumn();
            Column fkColumn = columnPair.getForeignKeyColumn();
            String pkColumnName = pkColumn.getParent().getName().equals(tableName) ? pkColumn.getName() : pkColumn.getFullName();
            String fkColumnName = fkColumn.getParent().getName().equals(tableName) ? fkColumn.getName() : fkColumn.getFullName();
            String keySequenceString = "";
            if (columnPair instanceof ForeignKeyColumnMap && ((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                int keySequence = ((ForeignKeyColumnMap)columnPair).getKeySequence();
                keySequenceString = String.format("%2d", keySequence);
            }
            this.out.println(this.formattingHelper.createDetailRow(keySequenceString, pkColumnName + this.formattingHelper.createArrow() + fkColumnName, ""));
        }
    }

    private void printForeignKeys(String tableName, ForeignKey[] foreignKeys) {
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            String name = foreignKey.getName();
            String updateRuleString = "";
            ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
            if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
                updateRuleString = ", on update " + updateRule.toString();
            }
            String deleteRuleString = "";
            ForeignKeyUpdateRule deleteRule = foreignKey.getDeleteRule();
            if (deleteRule != null && deleteRule != ForeignKeyUpdateRule.unknown) {
                deleteRuleString = ", on delete " + deleteRule.toString();
            }
            String ruleString = updateRule == deleteRule ? ", with " + deleteRule.toString() : updateRuleString + deleteRuleString;
            this.out.println(this.formattingHelper.createEmptyRow());
            String fkName = "";
            if (!((SchemaTextOptions)this.options).isHideForeignKeyNames()) {
                fkName = name;
            }
            String fkDetails = "[foreign key" + ruleString + "]";
            this.out.println(this.formattingHelper.createNameRow(fkName, fkDetails, false));
            ColumnMap[] columnPairs = foreignKey.getColumnPairs();
            this.printColumnPairs(tableName, columnPairs);
        }
    }

    private void printIndices(Index[] indices) {
        for (Index index : indices) {
            if (index == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            String indexName = "";
            if (!((SchemaTextOptions)this.options).isHideIndexNames()) {
                indexName = index.getName();
            }
            IndexType indexType = index.getType();
            String indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + " ";
            }
            String indexDetails = "[" + (index.isUnique() ? "" : "non-") + "unique " + indexTypeString + "index]";
            this.out.println(this.formattingHelper.createNameRow(indexName, indexDetails, false));
            this.printTableColumns(index.getColumns());
        }
    }

    private void printLint(Table table) {
        Lint[] lints = AnalyzedDatabase.getLint(table);
        if (lints != null && lints.length > 0) {
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow("", "[lint]", false));
            for (Lint lint : lints) {
                Object lintValue = lint.getLintValue();
                if (lintValue instanceof Boolean) {
                    if (!((Boolean)lintValue).booleanValue()) continue;
                    this.out.println(this.formattingHelper.createDefinitionRow(lint.getDescription()));
                    continue;
                }
                this.out.println(this.formattingHelper.createDefinitionRow(lint.getDescription() + Utility.NEWLINE + lint.getLintValueAsString()));
            }
        }
    }

    private void printPrimaryKey(Index primaryKey) {
        if (primaryKey != null) {
            String name = primaryKey.getName();
            this.out.println(this.formattingHelper.createEmptyRow());
            String pkName = "";
            if (!((SchemaTextOptions)this.options).isHidePrimaryKeyNames()) {
                pkName = name;
            }
            if (Utility.isBlank(pkName)) {
                pkName = "";
            }
            this.out.println(this.formattingHelper.createNameRow(pkName, "[primary key]", false));
            this.printTableColumns(primaryKey.getColumns());
        }
    }

    private void printPrivileges(Privilege[] privileges) {
        for (Privilege privilege : privileges) {
            if (privilege == null) continue;
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow(privilege.getName(), "[privilege]", false));
            for (Privilege.Grant grant : privilege.getGrants()) {
                String grantedFrom = grant.getGrantor() + this.formattingHelper.createArrow() + grant.getGrantee() + (grant.isGrantable() ? " (grantable)" : "");
                this.out.println(this.formattingHelper.createDetailRow("", grantedFrom, ""));
            }
        }
    }

    private void printProcedureColumns(ProcedureColumn[] columns) {
        for (ProcedureColumn column : columns) {
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getType().getTypeName() : column.getType().getDatabaseSpecificTypeName();
            StringBuilder columnType = new StringBuilder();
            columnType.append(columnTypeName).append(column.getWidth());
            if (column.getProcedureColumnType() != null) {
                columnType.append(", ").append(column.getProcedureColumnType().toString());
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition() + 1);
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, column.getName(), columnType.toString()));
        }
    }

    private void printTableColumns(Column[] columns) {
        for (Column column : columns) {
            String columnDetails;
            String columnName = column.getName();
            if (column instanceof IndexColumn) {
                columnDetails = ((IndexColumn)column).getSortSequence().name();
            } else {
                String columnTypeName = column.getType().getDatabaseSpecificTypeName();
                if (((SchemaTextOptions)this.options).isShowStandardColumnTypeNames()) {
                    columnTypeName = column.getType().getTypeName();
                }
                String columnType = columnTypeName + column.getWidth();
                String nullable = column.isNullable() ? "" : " not null";
                columnDetails = columnType + nullable;
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition());
            }
            this.out.println(this.formattingHelper.createDetailRow(ordinalNumberString, columnName, columnDetails));
        }
    }

    private void printText(String heading, String text) {
        if (Utility.isBlank(text)) {
            return;
        }
        this.out.println(this.formattingHelper.createEmptyRow());
        this.out.println(this.formattingHelper.createNameRow("", "[" + heading + "]", false));
        this.out.println(this.formattingHelper.createDefinitionRow(text));
    }

    private void printTriggers(Trigger[] triggers) {
        for (Trigger trigger : triggers) {
            if (trigger == null) continue;
            String timing = "";
            ConditionTimingType conditionTiming = trigger.getConditionTiming();
            EventManipulationType eventManipulationType = trigger.getEventManipulationType();
            if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown && eventManipulationType != null && eventManipulationType != EventManipulationType.unknown) {
                timing = ", " + (Object)((Object)conditionTiming) + " " + (Object)((Object)eventManipulationType);
            }
            String orientation = "";
            if (trigger.getActionOrientation() != null && trigger.getActionOrientation() != ActionOrientationType.unknown) {
                orientation = ", per " + (Object)((Object)trigger.getActionOrientation());
            }
            String triggerType = "[trigger" + timing + orientation + "]";
            triggerType = triggerType.toLowerCase(Locale.ENGLISH);
            String actionCondition = trigger.getActionCondition();
            String actionStatement = trigger.getActionStatement();
            this.out.println(this.formattingHelper.createEmptyRow());
            String triggerName = trigger.getName();
            this.out.println(this.formattingHelper.createNameRow(triggerName, triggerType, false));
            if (!Utility.isBlank(actionCondition)) {
                this.out.println(this.formattingHelper.createDefinitionRow(actionCondition));
            }
            if (Utility.isBlank(actionStatement)) continue;
            this.out.println(this.formattingHelper.createDefinitionRow(actionStatement));
        }
    }

    private void printWeakAssociations(Table table) {
        ColumnMap[] weakAssociations;
        String tableName = table.getName();
        for (ColumnMap weakAssociation : weakAssociations = AnalyzedDatabase.getWeakAssociations(table)) {
            this.out.println(this.formattingHelper.createEmptyRow());
            this.out.println(this.formattingHelper.createNameRow("", "[weak association]", false));
            this.printColumnPairs(tableName, weakAssociation);
        }
    }

    void begin() throws SchemaCrawlerException {
        if (!this.outputOptions.isNoHeader()) {
            this.out.println(this.formattingHelper.createDocumentStart());
        }
    }

    void end() throws SchemaCrawlerException {
        if (!this.outputOptions.isNoFooter()) {
            this.out.println(this.formattingHelper.createDocumentEnd());
        }
        this.out.flush();
        this.outputOptions.closeOutputWriter(this.out);
    }

    void handle(ColumnDataType columnDataType) throws SchemaCrawlerException {
        if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
            this.out.print(this.formattingHelper.createObjectStart(""));
            this.printColumnDataType(columnDataType);
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    void handle(Procedure procedure) {
        boolean underscore = this.schemaTextDetailType != SchemaTextDetailType.list_objects;
        String procedureTypeDetail = "procedure, " + (Object)((Object)procedure.getType());
        String nameRow = this.formattingHelper.createNameRow(procedure.getFullName(), "[" + procedureTypeDetail + "]", underscore);
        if (this.schemaTextDetailType != SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
        this.out.println(nameRow);
        if (this.schemaTextDetailType != SchemaTextDetailType.list_objects) {
            this.printProcedureColumns(procedure.getColumns());
            this.printText("definition", procedure.getDefinition());
            if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
                this.printText("remarks", procedure.getRemarks());
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    void handle(Table table) {
        boolean underscore = this.schemaTextDetailType != SchemaTextDetailType.list_objects;
        String nameRow = this.formattingHelper.createNameRow(table.getFullName(), "[" + (Object)((Object)table.getType()) + "]", underscore);
        if (this.schemaTextDetailType != SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
        this.out.println(nameRow);
        if (this.schemaTextDetailType != SchemaTextDetailType.list_objects) {
            this.printTableColumns(table.getColumns());
            this.printPrimaryKey(table.getPrimaryKey());
            this.printForeignKeys(table.getName(), table.getForeignKeys());
            if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
                this.printWeakAssociations(table);
            }
            this.printIndices(table.getIndices());
            if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
                this.printCheckConstraints(table.getCheckConstraints());
                this.printPrivileges(table.getPrivileges());
                this.printTriggers(table.getTriggers());
            }
            if (table instanceof View) {
                View view = (View)table;
                this.printText("definition", view.getDefinition());
            }
            if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
                this.printText("remarks", table.getRemarks());
                this.printLint(table);
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        this.out.flush();
    }

    void handleColumnDataTypesEnd() {
    }

    void handleColumnDataTypesStart() {
        if (this.schemaTextDetailType.isGreaterThanOrEqualTo(SchemaTextDetailType.verbose_schema)) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types"));
        }
    }

    void handleProceduresEnd() throws SchemaCrawlerException {
        if (this.schemaTextDetailType == SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    void handleProceduresStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Procedures"));
        if (this.schemaTextDetailType == SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
    }

    void handleTablesEnd() throws SchemaCrawlerException {
        if (this.schemaTextDetailType == SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectEnd());
        }
    }

    void handleTablesStart() throws SchemaCrawlerException {
        this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables"));
        if (this.schemaTextDetailType == SchemaTextDetailType.list_objects) {
            this.out.print(this.formattingHelper.createObjectStart(""));
        }
    }
}

