/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.util;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.util.Entities;
import sf.util.Utility;

final class TableCell {
    private final OutputFormat outputFormat;
    private final String styleClass;
    private final int colSpan;
    private final int characterWidth;
    private final Align align;
    private final String text;

    private static String escapeAndQuoteCsv(String text) {
        int QUOTE = 34;
        int SEPARATOR = 44;
        String value = String.valueOf(text);
        int length = value.length();
        if (length == 0) {
            return "\"\"";
        }
        if (value.indexOf(44) < 0 && value.indexOf(34) < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                sb.append('\"').append(c);
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
        return sb.toString();
    }

    TableCell(String text, int characterWidth, Align align, int colSpan, String styleClass, OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        this.colSpan = colSpan;
        this.styleClass = styleClass;
        this.text = text;
        this.characterWidth = characterWidth;
        this.align = align;
    }

    TableCell(String text, String styleClass, OutputFormat outputFormat) {
        this(text, 0, Align.left, 1, styleClass, outputFormat);
    }

    public String toString() {
        if (this.outputFormat == OutputFormat.html) {
            return this.toHtmlString();
        }
        return this.toPlainTextString();
    }

    private String toHtmlString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<td");
        if (this.colSpan > 1) {
            buffer.append(" colspan='").append(this.colSpan).append("'");
        }
        if (!Utility.isBlank(this.styleClass)) {
            buffer.append(" class='").append(this.styleClass).append("'");
        }
        buffer.append(">");
        buffer.append(Entities.XML.escape(String.valueOf(this.text)));
        buffer.append("</td>");
        return buffer.toString();
    }

    private String toPlainTextString() {
        if (this.outputFormat == OutputFormat.csv) {
            return TableCell.escapeAndQuoteCsv(this.text);
        }
        if (this.characterWidth > 0) {
            if (this.align == Align.right) {
                return String.format("%" + this.characterWidth + "s", this.text);
            }
            return String.format("%-" + this.characterWidth + "s", this.text);
        }
        return this.text;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Align {
        left,
        right;

    }
}

