/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.spin.node.CacheInfo;
import org.spin.node.ModuleVersionInfo;
import org.spin.node.NodeState;
import org.spin.node.QueryAction;
import org.spin.node.QueryActionInfo;
import org.spin.node.QueryActionMap;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.cache.MemoryResidentCache;
import org.spin.node.cache.ReadOnlyResultStore;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.CryptoException;
import org.spin.tools.crypto.PKITool;
import org.spin.tools.crypto.signature.CertData;
import org.spin.tools.crypto.signature.CertID;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="NodeStatusInfo")
@XmlRootElement
public final class NodeStatusInfo {
    private static final Logger log = Logger.getLogger(NodeStatusInfo.class);
    private final List<QueryActionInfo> queryActionInfos = Util.makeArrayList();
    private final ModuleVersionInfo moduleVersionInfo;
    private final int totalQueriesMade;
    private final int countOfQueryTypes;
    private final CacheInfo cacheInfo;
    private final NodeStateTag nodeState;
    private final CertID nodeID;
    private final String nodeURL;

    private NodeStatusInfo() {
        this.nodeURL = null;
        this.nodeState = null;
        this.cacheInfo = null;
        this.nodeID = null;
        this.moduleVersionInfo = null;
        this.countOfQueryTypes = 0;
        this.totalQueriesMade = 0;
    }

    NodeStatusInfo(String nodeURL, QueryActionMap queryMapContext, MemoryResidentCache cache, Class<? extends NodeState> clazz) {
        this(nodeURL, queryMapContext, cache, clazz, NodeStateTag.Online);
    }

    NodeStatusInfo(String nodeURL, QueryActionMap queryMapContext, MemoryResidentCache cache, Class<? extends NodeState> clazz, NodeStateTag nodeState) {
        this.nodeURL = nodeURL;
        this.cacheInfo = cache != null ? new CacheInfo(cache.getResultStore()) : null;
        this.nodeID = cache != null ? cache.getNodeID() : null;
        this.nodeState = nodeState;
        if (queryMapContext != null) {
            this.setQueryActionInfos(queryMapContext);
        }
        this.countOfQueryTypes = 0;
        this.totalQueriesMade = 0;
        if (clazz != null) {
            ReadOnlyResultStore readOnlyResultStore = cache != null ? cache.getResultStore() : null;
            this.moduleVersionInfo = new ModuleVersionInfo(clazz, readOnlyResultStore, queryMapContext);
        } else {
            this.moduleVersionInfo = null;
        }
    }

    private final void setQueryActionInfos(QueryActionMap queryMapContext) {
        Collection<String> queryTypes = queryMapContext.getQueryTypes();
        for (String queryType : queryTypes) {
            try {
                QueryAction<?> queryAdapter = queryMapContext.getQueryAction(queryType);
                this.queryActionInfos.add(new QueryActionInfo(queryType, queryAdapter));
            }
            catch (UnknownQueryTypeException e) {
                log.warn((Object)("Unknown query type '" + queryType + "': is another thread modifying the QueryMap?"));
            }
        }
    }

    public final String getNodeURL() {
        return this.nodeURL;
    }

    public final NodeStateTag getNodeState() {
        return this.nodeState;
    }

    public final Collection<QueryActionInfo> getQueryActionInfos() {
        return this.queryActionInfos;
    }

    public final CacheInfo getCacheInfo() {
        return this.cacheInfo;
    }

    public final int getNumQueryTypes() {
        return this.countOfQueryTypes;
    }

    public final Map<String, String> getModuleToVersionInfo() {
        if (this.moduleVersionInfo != null) {
            return Util.makeHashMap(this.moduleVersionInfo.getModuleNameToVersion());
        }
        return null;
    }

    public final String getResultStoreClassName() {
        if (this.moduleVersionInfo != null) {
            return this.moduleVersionInfo.getResultStoreClassName();
        }
        return null;
    }

    public final CertID getNodeID() {
        return this.nodeID;
    }

    public final CertData getSerializablePublicCert() throws ConfigException, CryptoException {
        if (PKITool.getInstance().containsX509Certificate(this.nodeID)) {
            return PKITool.getX509Data((X509Certificate)PKITool.getInstance().getX509Certificate(this.nodeID));
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeURL == null ? 0 : this.nodeURL.hashCode());
        result = 31 * result + (this.cacheInfo == null ? 0 : this.cacheInfo.hashCode());
        result = 31 * result + this.countOfQueryTypes;
        result = 31 * result + (this.moduleVersionInfo == null ? 0 : this.moduleVersionInfo.hashCode());
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.nodeState == null ? 0 : this.nodeState.hashCode());
        result = 31 * result + (this.queryActionInfos == null ? 0 : this.queryActionInfos.hashCode());
        result = 31 * result + this.totalQueriesMade;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStatusInfo other = (NodeStatusInfo)obj;
        if (this.cacheInfo == null ? other.cacheInfo != null : !this.cacheInfo.equals(other.cacheInfo)) {
            return false;
        }
        if (this.countOfQueryTypes != other.countOfQueryTypes) {
            return false;
        }
        if (this.moduleVersionInfo == null ? other.moduleVersionInfo != null : !this.moduleVersionInfo.equals(other.moduleVersionInfo)) {
            return false;
        }
        if (this.nodeURL == null ? other.nodeURL != null : !this.nodeURL.equals(other.nodeURL)) {
            return false;
        }
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals((Object)other.nodeID)) {
            return false;
        }
        if (this.nodeState == null ? other.nodeState != null : !this.nodeState.equals((Object)other.nodeState)) {
            return false;
        }
        if (this.queryActionInfos == null ? other.queryActionInfos != null : !this.queryActionInfos.equals(other.queryActionInfos)) {
            return false;
        }
        return this.totalQueriesMade == other.totalQueriesMade;
    }

    public static enum NodeStateTag {
        Online,
        Offline;

    }
}

