/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.spin.identity.IdentityServiceException;
import org.spin.message.AckNack;
import org.spin.message.BroadcastResults;
import org.spin.message.PropagationFlag;
import org.spin.message.QueryInfo;
import org.spin.message.QueryInput;
import org.spin.message.Response;
import org.spin.message.ResultSet;
import org.spin.message.StatusCode;
import org.spin.node.NodeException;
import org.spin.node.NodeStatusInfo;
import org.spin.node.QueryException;
import org.spin.node.SpinNode;
import org.spin.node.cache.CacheException;
import org.spin.node.connector.ConnectorUtils;
import org.spin.node.connector.NodeConnector;
import org.spin.node.connector.URLHandle;
import org.spin.tools.Util;
import org.spin.tools.crypto.signature.Identity;

public final class LazyLoadingJAXWSNodeConnector
extends NodeConnector {
    private final URLHandle nodeWSDLURL;
    private SpinNode node;
    private final int maxWaitTime;

    @Override
    public String debug(String queryID) {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        return this.getProxy().debug(queryID);
    }

    public LazyLoadingJAXWSNodeConnector(String nodeWSDLURL, int timeoutPeriod) {
        this(URLHandle.fromString(nodeWSDLURL), timeoutPeriod);
    }

    public LazyLoadingJAXWSNodeConnector(URL nodeWSDLURL, int maxWaitTime) {
        this(URLHandle.fromURL(nodeWSDLURL), maxWaitTime);
    }

    private LazyLoadingJAXWSNodeConnector(URLHandle nodeWSDLURL, int maxWaitTime) {
        super(String.valueOf(nodeWSDLURL));
        Util.guardNotNull((Object)nodeWSDLURL);
        Util.require((maxWaitTime > 0 ? 1 : 0) != 0);
        this.nodeWSDLURL = nodeWSDLURL;
        this.maxWaitTime = maxWaitTime;
    }

    public synchronized SpinNode getProxy() {
        return this.node;
    }

    URLHandle getNodeWSDLURL() {
        return this.nodeWSDLURL;
    }

    int getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public final synchronized <E extends Throwable> void lazyLoadWSDLIfNecessary(Class<E> exceptionClassToThrow) throws E {
        if (this.node == null) {
            URL nodeURL = null;
            try {
                nodeURL = this.nodeWSDLURL.value();
            }
            catch (MalformedURLException e) {
                ConnectorUtils.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Malformed URL: '", this.nodeWSDLURL, "', cannot connect to WSDL using JAXWS"}), e);
            }
            try {
                this.node = this.getSpinNode(nodeURL);
            }
            catch (NodeException e) {
                ConnectorUtils.rethrow(exceptionClassToThrow, Util.concat((Object[])new Object[]{"Error connecting to Node at URL: '", this.nodeWSDLURL, "'"}), e);
            }
        }
    }

    private final SpinNode getSpinNode(URL nodeURL) {
        if (nodeURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        try {
            return this.makeJAXWSProxy(nodeURL);
        }
        catch (Exception e) {
            throw new NodeException("Error connecting to JAXWS URL " + nodeURL, e);
        }
    }

    public SpinNode makeJAXWSProxyForCargo(URL nodeURL) {
        return this.makeJAXWSProxy(nodeURL);
    }

    private SpinNode makeJAXWSProxy(URL nodeURL) {
        if (LazyLoadingJAXWSNodeConnector.isSSL(nodeURL)) {
            ConnectorUtils.initializeConduitForSSL();
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(SpinNode.class);
        factory.setAddress(nodeURL.toString());
        SpinNode port = (SpinNode)factory.create();
        Client client = ClientProxy.getClient((Object)port);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.setTlsClientParameters(ConnectorUtils.getTlsParams());
        this.setTimeouts(http);
        return port;
    }

    private synchronized void setTimeouts(HTTPConduit conduit) {
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        conduit.setClient(httpClientPolicy);
        httpClientPolicy.setConnectionTimeout((long)this.maxWaitTime);
        httpClientPolicy.setReceiveTimeout((long)this.maxWaitTime);
    }

    @Override
    public synchronized NodeStatusInfo getNodeStatus() {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        return this.getProxy().getNodeStatus();
    }

    @Override
    public synchronized Identity certify(String domain, String username, String password) {
        this.lazyLoadWSDLIfNecessary(IdentityServiceException.class);
        return this.getProxy().certify(domain, username, password);
    }

    @Override
    public synchronized AckNack query(QueryInfo queryInfo, QueryInput criteria) {
        this.lazyLoadWSDLIfNecessary(QueryException.class);
        return this.getProxy().query(queryInfo, criteria);
    }

    @Override
    public synchronized ResultSet blockingQuery(QueryInfo queryInfo, QueryInput criteria) {
        this.lazyLoadWSDLIfNecessary(QueryException.class);
        return this.getProxy().blockingQuery(queryInfo, criteria);
    }

    @Override
    public synchronized void initQuery(QueryInfo queryInfo) {
        this.lazyLoadWSDLIfNecessary(RuntimeException.class);
        this.getProxy().initQuery(queryInfo);
    }

    @Override
    public synchronized void aggregate(QueryInfo queryInfo, Response resultData) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        this.getProxy().aggregate(queryInfo, resultData);
    }

    @Override
    public synchronized int countResponses(String queryID) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().countResponses(queryID);
    }

    @Override
    public synchronized ResultSet getResult(String queryID, Identity requestorID) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().getResult(queryID, requestorID);
    }

    @Override
    public synchronized ResultSet getResultNoDelete(String queryID, Identity requestorID) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().getResultNoDelete(queryID, requestorID);
    }

    @Override
    public synchronized boolean hasUpdate(String queryID, int numResponders) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().hasUpdate(queryID, numResponders);
    }

    @Override
    public synchronized boolean isComplete(String queryID) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().isComplete(queryID);
    }

    @Override
    public synchronized PropagationFlag expectResponse(QueryInfo queryInfo, Collection<StatusCode> statuses, BroadcastResults broadcastResults) {
        this.lazyLoadWSDLIfNecessary(CacheException.class);
        return this.getProxy().expectResponse(queryInfo, statuses, broadcastResults);
    }
}

