/*
 * Decompiled with CFR 0.152.
 */
package org.spin.node.connector;

import java.net.URL;
import org.spin.node.NodeException;
import org.spin.node.SpinNode;
import org.spin.node.connector.DefensiveCopyNodeConnector;
import org.spin.node.connector.LazyLoadingJAXWSNodeConnector;
import org.spin.tools.Util;

public abstract class NodeConnector
implements SpinNode {
    public static final Long defaultMaxWaitTime = 90000L;
    private final String nodeName;

    NodeConnector(String nodeName) {
        if (nodeName == null) {
            throw new NodeException("Null node name passed in");
        }
        this.nodeName = nodeName;
    }

    public static final NodeConnector instance(String nodeWSDLURL) {
        return NodeConnector.instance(nodeWSDLURL, defaultMaxWaitTime.intValue());
    }

    public static final NodeConnector instance(String nodeWSDLURL, int timeoutPeriod) {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL, timeoutPeriod);
    }

    public static final NodeConnector instance(URL nodeWSDLURL) {
        return NodeConnector.instance(nodeWSDLURL, defaultMaxWaitTime.intValue());
    }

    public static final NodeConnector instance(URL nodeWSDLURL, int timeoutPeriod) {
        if (nodeWSDLURL == null) {
            throw new NodeException("Null Node URL passed in");
        }
        return new LazyLoadingJAXWSNodeConnector(nodeWSDLURL, timeoutPeriod);
    }

    public static final NodeConnector instance(SpinNode node) {
        if (node == null) {
            throw new NodeException("Null Node passed in");
        }
        return new DefensiveCopyNodeConnector(node);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    static boolean isSSL(URL nodeWSDLURL) {
        Util.guardNotNull((Object)nodeWSDLURL);
        return nodeWSDLURL.getProtocol().equalsIgnoreCase("https");
    }
}

