/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableDatabaseProperty;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.MutableJdbcDriverProperty;
import schemacrawler.crawl.MutableSchema;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.SearchableType;

final class DatabaseInfoRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(DatabaseInfoRetriever.class.getName());
    private static final List<String> ignoreMethods = Arrays.asList("getDatabaseProductName", "getDatabaseProductVersion", "getURL", "getUserName", "getDriverName", "getDriverVersion");

    private static boolean isDatabasePropertiesResultSetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isPropertiesResultSetMethod = returnType.equals(ResultSet.class) && method.getParameterTypes().length == 0;
        return isPropertiesResultSetMethod;
    }

    private static boolean isDatabasePropertyMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean notPropertyMethod = returnType.equals(ResultSet.class) || returnType.equals(Connection.class) || method.getParameterTypes().length > 0;
        return !notPropertyMethod;
    }

    private static boolean isDatabasePropertyResultSetType(Method method) {
        Object[] databasePropertyResultSetTypes = new String[]{"deletesAreDetected", "insertsAreDetected", "updatesAreDetected", "othersDeletesAreVisible", "othersInsertsAreVisible", "othersUpdatesAreVisible", "ownDeletesAreVisible", "ownInsertsAreVisible", "ownUpdatesAreVisible", "supportsResultSetType"};
        boolean isDatabasePropertyResultSetType = Arrays.binarySearch(databasePropertyResultSetTypes, method.getName()) >= 0;
        return isDatabasePropertyResultSetType;
    }

    private static MutableDatabaseProperty retrieveResultSetTypeProperty(DatabaseMetaData dbMetaData, Method method, int resultSetType, String resultSetTypeName) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName() + "For" + resultSetTypeName + "ResultSets";
        Boolean propertyValue = null;
        propertyValue = (Boolean)method.invoke((Object)dbMetaData, resultSetType);
        return new MutableDatabaseProperty(name, (Object)propertyValue);
    }

    DatabaseInfoRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveAdditionalDatabaseInfo() throws SQLException {
        Method[] methods;
        DatabaseMetaData dbMetaData = this.getMetaData();
        MutableDatabaseInfo dbInfo = this.database.getDatabaseInfo();
        ArrayList<MutableDatabaseProperty> dbProperties = new ArrayList<MutableDatabaseProperty>();
        for (Method method : methods = DatabaseMetaData.class.getMethods()) {
            try {
                if (ignoreMethods.contains(method.getName())) continue;
                if (DatabaseInfoRetriever.isDatabasePropertyMethod(method)) {
                    String[] value;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINER, "Retrieving database property using method: " + method);
                    }
                    if ((value = method.invoke((Object)dbMetaData, new Object[0])) != null && method.getName().endsWith("s") && value instanceof String) {
                        value = ((String)value).split(",");
                    }
                    dbProperties.add(new MutableDatabaseProperty(method.getName(), value));
                    continue;
                }
                if (DatabaseInfoRetriever.isDatabasePropertiesResultSetMethod(method)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINER, "Retrieving database property using method: " + method);
                    }
                    ResultSet results = (ResultSet)method.invoke((Object)dbMetaData, new Object[0]);
                    List<String> resultsList = DatabaseInfoRetriever.readResultsVector(results);
                    dbProperties.add(new MutableDatabaseProperty(method.getName(), resultsList.toArray(new String[resultsList.size()])));
                    continue;
                }
                if (!DatabaseInfoRetriever.isDatabasePropertyResultSetType(method)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINER, "Retrieving database property using method: " + method);
                }
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1003, "TYPE_FORWARD_ONLY"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1004, "TYPE_SCROLL_INSENSITIVE"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1005, "TYPE_SCROLL_SENSITIVE"));
            }
            catch (IllegalAccessException e) {
                LOGGER.log(Level.FINE, "Could not execute method, " + method, e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(Level.FINE, "Could not execute method, " + method, e.getCause());
            }
        }
        dbInfo.addAll(dbProperties);
    }

    void retrieveAdditionalJdbcDriverInfo() throws SQLException {
        DatabaseMetaData dbMetaData = this.getMetaData();
        String url = dbMetaData.getURL();
        MutableJdbcDriverInfo driverInfo = this.database.getJdbcDriverInfo();
        if (driverInfo != null) {
            try {
                DriverPropertyInfo[] propertyInfo;
                Driver jdbcDriver = DriverManager.getDriver(url);
                for (DriverPropertyInfo driverPropertyInfo : propertyInfo = jdbcDriver.getPropertyInfo(url, new Properties())) {
                    driverInfo.addJdbcDriverProperty(new MutableJdbcDriverProperty(driverPropertyInfo));
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not obtain JDBC driver information", e);
            }
        }
    }

    void retrieveAdditionalSchemaCrawlerInfo() {
        this.database.getSchemaCrawlerInfo().setAdditionalSchemaCrawlerInfo();
    }

    void retrieveDatabaseInfo() throws SQLException {
        DatabaseMetaData dbMetaData = this.getMetaData();
        MutableDatabaseInfo dbInfo = this.database.getDatabaseInfo();
        dbInfo.setUserName(dbMetaData.getUserName());
        dbInfo.setProductName(dbMetaData.getDatabaseProductName());
        dbInfo.setProductVersion(dbMetaData.getDatabaseProductVersion());
    }

    void retrieveJdbcDriverInfo() throws SQLException {
        DatabaseMetaData dbMetaData = this.getMetaData();
        String url = dbMetaData.getURL();
        MutableJdbcDriverInfo driverInfo = this.database.getJdbcDriverInfo();
        if (driverInfo != null) {
            driverInfo.setDriverName(dbMetaData.getDriverName());
            driverInfo.setDriverVersion(dbMetaData.getDriverVersion());
            driverInfo.setConnectionUrl(url);
            Driver jdbcDriver = DriverManager.getDriver(url);
            driverInfo.setJdbcDriverClassName(jdbcDriver.getClass().getName());
            driverInfo.setJdbcCompliant(jdbcDriver.jdbcCompliant());
        }
    }

    void retrieveSchemaCrawlerInfo() {
        this.database.getSchemaCrawlerInfo().setSchemaCrawlerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveSystemColumnDataTypes() throws SQLException {
        MutableSchema systemSchema = new MutableSchema();
        MetadataResultSet results = new MetadataResultSet(this.getMetaData().getTypeInfo());
        try {
            while (results.next()) {
                String typeName = results.getString("TYPE_NAME");
                int dataType = results.getInt("DATA_TYPE", 0);
                LOGGER.log(Level.FINER, String.format("Retrieving data type: %s (with type id %d)", typeName, dataType));
                long precision = results.getLong("PRECISION", 0L);
                String literalPrefix = results.getString("LITERAL_PREFIX");
                String literalSuffix = results.getString("LITERAL_SUFFIX");
                String createParameters = results.getString("CREATE_PARAMS");
                boolean isNullable = results.getInt("NULLABLE", 2) == 1;
                boolean isCaseSensitive = results.getBoolean("CASE_SENSITIVE");
                SearchableType searchable = SearchableType.valueOf(results.getInt("SEARCHABLE", SearchableType.unknown.ordinal()));
                boolean isUnsigned = results.getBoolean("UNSIGNED_ATTRIBUTE");
                boolean isFixedPrecisionScale = results.getBoolean("FIXED_PREC_SCALE");
                boolean isAutoIncremented = results.getBoolean("AUTO_INCREMENT");
                String localTypeName = results.getString("LOCAL_TYPE_NAME");
                int minimumScale = results.getInt("MINIMUM_SCALE", 0);
                int maximumScale = results.getInt("MAXIMUM_SCALE", 0);
                int numPrecisionRadix = results.getInt("NUM_PREC_RADIX", 0);
                MutableColumnDataType columnDataType = new MutableColumnDataType(systemSchema, typeName);
                columnDataType.setType(dataType, null);
                columnDataType.setPrecision(precision);
                columnDataType.setLiteralPrefix(literalPrefix);
                columnDataType.setLiteralSuffix(literalSuffix);
                columnDataType.setCreateParameters(createParameters);
                columnDataType.setNullable(isNullable);
                columnDataType.setCaseSensitive(isCaseSensitive);
                columnDataType.setSearchable(searchable);
                columnDataType.setUnsigned(isUnsigned);
                columnDataType.setFixedPrecisionScale(isFixedPrecisionScale);
                columnDataType.setAutoIncrementable(isAutoIncremented);
                columnDataType.setLocalTypeName(localTypeName);
                columnDataType.setMinimumScale(minimumScale);
                columnDataType.setMaximumScale(maximumScale);
                columnDataType.setNumPrecisionRadix(numPrecisionRadix);
                columnDataType.addAttributes(results.getAttributes());
                this.database.addSystemColumnDataType(columnDataType);
            }
        }
        finally {
            results.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveUserDefinedColumnDataTypes(String catalogName, String schemaName) throws SQLException {
        MetadataResultSet results = new MetadataResultSet(this.getMetaData().getUDTs(catalogName, schemaName, "%", null));
        try {
            while (results.next()) {
                String typeName = results.getString("TYPE_NAME");
                LOGGER.log(Level.FINER, "Retrieving data type: " + typeName);
                short dataType = results.getShort("DATA_TYPE", (short)0);
                String className = results.getString("CLASS_NAME");
                String remarks = results.getString("REMARKS");
                short baseTypeValue = results.getShort("BASE_TYPE", (short)0);
                MutableSchema schema = this.lookupSchema(catalogName, schemaName);
                if (schema == null) {
                    LOGGER.log(Level.FINE, String.format("Cannot find schema, %s.%s", catalogName, schemaName));
                    continue;
                }
                MutableColumnDataType baseType = this.lookupColumnDataTypeByType(schema, baseTypeValue);
                MutableColumnDataType columnDataType = new MutableColumnDataType(schema, typeName);
                columnDataType.setUserDefined(true);
                columnDataType.setType(dataType, className);
                columnDataType.setBaseType(baseType);
                columnDataType.setRemarks(remarks);
                columnDataType.addAttributes(results.getAttributes());
                schema.addColumnDataType(columnDataType);
            }
        }
        finally {
            results.close();
        }
    }
}

