/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.JavaSqlType;
import schemacrawler.schemacrawler.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSqlTypesUtility {
    private static final Logger LOGGER = Logger.getLogger(JavaSqlTypesUtility.class.getName());
    private static final Map<Integer, JavaSqlType> JAVA_SQL_TYPES_BY_TYPE;
    private static final Map<String, JavaSqlType> JAVA_SQL_TYPES_BY_TYPE_NAME;

    public static JavaSqlType lookupSqlDataType(int type) {
        JavaSqlType sqlDataType = JAVA_SQL_TYPES_BY_TYPE.get(type);
        if (sqlDataType == null) {
            sqlDataType = JavaSqlType.UNKNOWN;
        }
        return sqlDataType;
    }

    public static JavaSqlType lookupSqlDataType(String typeName) {
        JavaSqlType sqlDataType = JAVA_SQL_TYPES_BY_TYPE_NAME.get(typeName);
        if (sqlDataType == null) {
            sqlDataType = JavaSqlType.UNKNOWN;
        }
        return sqlDataType;
    }

    private static Map<Integer, JavaSqlType> mapJavaSqlTypesByType(List<JavaSqlType> javaSqlTypes) {
        HashMap<Integer, JavaSqlType> javaSqlTypesByTypeMap = new HashMap<Integer, JavaSqlType>();
        if (javaSqlTypes != null) {
            for (JavaSqlType javaSqlType : javaSqlTypes) {
                javaSqlTypesByTypeMap.put(javaSqlType.getJavaSqlType(), javaSqlType);
            }
        }
        return Collections.unmodifiableMap(javaSqlTypesByTypeMap);
    }

    private static Map<String, JavaSqlType> mapJavaSqlTypesByTypeName(List<JavaSqlType> javaSqlTypes) {
        HashMap<String, JavaSqlType> javaSqlTypesByTypeNameMap = new HashMap<String, JavaSqlType>();
        if (javaSqlTypes != null) {
            for (JavaSqlType javaSqlType : javaSqlTypes) {
                javaSqlTypesByTypeNameMap.put(javaSqlType.getJavaSqlTypeName(), javaSqlType);
            }
        }
        return Collections.unmodifiableMap(javaSqlTypesByTypeNameMap);
    }

    private static List<JavaSqlType> readJavaSqlTypes() {
        Map<String, JavaSqlType.JavaSqlTypeGroup> javaSqlTypeGroupsMap = JavaSqlTypesUtility.readJavaSqlTypesGroupsMap();
        Map<String, String> javaSqlTypesClassNames = JavaSqlTypesUtility.readJavaSqlTypesClassNameMap();
        Map<String, String> javaSqlTypesProperties = JavaSqlTypesUtility.readPropertiesResource("/java.sql.Types.properties");
        ArrayList<JavaSqlType> javaSqlTypes = new ArrayList<JavaSqlType>();
        for (Map.Entry<String, String> javaSqlTypesEntry : javaSqlTypesProperties.entrySet()) {
            if (javaSqlTypesEntry.getKey() == null || javaSqlTypesEntry.getValue() == null) continue;
            Integer javaSqlType = Integer.parseInt(javaSqlTypesEntry.getValue());
            String javaSqlTypeName = javaSqlTypesEntry.getKey();
            String javaSqlTypesClassName = javaSqlTypesClassNames.get(javaSqlTypeName);
            JavaSqlType.JavaSqlTypeGroup javaSqlTypeGroup = javaSqlTypeGroupsMap.get(javaSqlTypeName);
            javaSqlTypes.add(new JavaSqlType(javaSqlType, javaSqlTypeName, javaSqlTypesClassName, javaSqlTypeGroup));
        }
        return Collections.unmodifiableList(javaSqlTypes);
    }

    private static Map<String, String> readJavaSqlTypesClassNameMap() {
        return JavaSqlTypesUtility.readPropertiesResource("/java.sql.Types.mappings.properties");
    }

    private static Map<String, JavaSqlType.JavaSqlTypeGroup> readJavaSqlTypesGroupsMap() {
        HashMap<String, JavaSqlType.JavaSqlTypeGroup> javaSqlTypesGroupsMap = new HashMap<String, JavaSqlType.JavaSqlTypeGroup>();
        Map<String, String> javaSqlTypesGroups = JavaSqlTypesUtility.readPropertiesResource("/java.sql.Types.groups.properties");
        for (Map.Entry<String, String> javaSqlTypesGroupsEntry : javaSqlTypesGroups.entrySet()) {
            try {
                String javaSqlTypeName = javaSqlTypesGroupsEntry.getKey();
                JavaSqlType.JavaSqlTypeGroup group = JavaSqlType.JavaSqlTypeGroup.valueOf(javaSqlTypesGroupsEntry.getValue());
                javaSqlTypesGroupsMap.put(javaSqlTypeName, group);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Could not read java.sql.Types groups", e);
            }
        }
        return Collections.unmodifiableMap(javaSqlTypesGroupsMap);
    }

    private static Map<String, String> readPropertiesResource(String resource) {
        InputStream inputStream = JavaSqlTypesUtility.class.getResourceAsStream(resource);
        HashMap properties = inputStream != null ? Config.load(inputStream) : new HashMap();
        return properties;
    }

    private JavaSqlTypesUtility() {
    }

    static {
        List<JavaSqlType> javaSqlTypes = JavaSqlTypesUtility.readJavaSqlTypes();
        JAVA_SQL_TYPES_BY_TYPE = JavaSqlTypesUtility.mapJavaSqlTypesByType(javaSqlTypes);
        JAVA_SQL_TYPES_BY_TYPE_NAME = JavaSqlTypesUtility.mapJavaSqlTypesByTypeName(javaSqlTypes);
    }
}

