/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractColumn;
import schemacrawler.crawl.MutablePrivilege;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Column;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Privilege;

class MutableColumn
extends AbstractColumn
implements Column {
    private static final long serialVersionUID = 3834591019449528633L;
    private String defaultValue;
    private boolean isPartOfPrimaryKey;
    private boolean isPartOfUniqueIndex;
    private MutableColumn referencedColumn;
    private final NamedObjectList<MutablePrivilege> privileges = new NamedObjectList();

    MutableColumn(DatabaseObject parent, String name) {
        super(parent, name);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public MutablePrivilege getPrivilege(String name) {
        return this.privileges.lookup(this, name);
    }

    public Privilege[] getPrivileges() {
        return this.privileges.values().toArray(new Privilege[this.privileges.size()]);
    }

    public Column getReferencedColumn() {
        return this.referencedColumn;
    }

    public boolean isPartOfForeignKey() {
        return this.referencedColumn != null;
    }

    public boolean isPartOfPrimaryKey() {
        return this.isPartOfPrimaryKey;
    }

    public boolean isPartOfUniqueIndex() {
        return this.isPartOfUniqueIndex;
    }

    void addPrivilege(MutablePrivilege privilege) {
        this.privileges.add(privilege);
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    void setPartOfPrimaryKey(boolean partOfPrimaryKey) {
        this.isPartOfPrimaryKey = partOfPrimaryKey;
    }

    void setPartOfUniqueIndex(boolean partOfUniqueIndex) {
        this.isPartOfUniqueIndex = partOfUniqueIndex;
    }

    void setReferencedColumn(MutableColumn referencedColumn) {
        this.referencedColumn = referencedColumn;
    }
}

