/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.MutableDatabaseProperty;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MutableDatabaseInfo
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String userName;
    private String productName;
    private String productVersion;
    private final Set<DatabaseProperty> databaseProperties = new HashSet<DatabaseProperty>();

    MutableDatabaseInfo() {
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public DatabaseProperty[] getProperties() {
        Object[] properties = this.databaseProperties.toArray(new DatabaseProperty[this.databaseProperties.size()]);
        Arrays.sort(properties);
        return properties;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("-- database: ").append(this.getProductName()).append(" ").append(this.getProductVersion()).append(NEWLINE);
        return info.toString();
    }

    void addAll(Collection<MutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void setProductName(String productName) {
        this.productName = productName;
    }

    void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }
}

