/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import schemacrawler.crawl.MutableProperty;
import schemacrawler.schema.DatabaseProperty;

class MutableDatabaseProperty
extends MutableProperty
implements DatabaseProperty {
    private static final long serialVersionUID = -7150431683440256142L;
    private static final Set<Map.Entry<String, String>> acronyms;
    private transient String description;

    MutableDatabaseProperty(String name, Object value) {
        super(name, (Serializable)value);
        this.buildDescription();
    }

    public int compareTo(DatabaseProperty otherDbProperty) {
        if (otherDbProperty == null) {
            return -1;
        }
        return this.getDescription().toLowerCase().compareTo(otherDbProperty.getDescription().toLowerCase());
    }

    public String getDescription() {
        this.buildDescription();
        return this.description;
    }

    public String toString() {
        return this.getDescription() + " = " + this.getValue();
    }

    private void buildDescription() {
        if (this.description == null) {
            String get = "get";
            this.description = this.getName();
            if (this.description.startsWith("get")) {
                this.description = this.description.substring("get".length());
            }
            for (Map.Entry<String, String> acronym : acronyms) {
                this.description = this.description.replaceAll(acronym.getKey(), acronym.getValue());
            }
            int strLen = this.description.length();
            StringBuilder buffer = new StringBuilder(strLen);
            for (int i = 0; i < strLen; ++i) {
                char ch = this.description.charAt(i);
                if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                    buffer.append(' ').append(Character.toLowerCase(ch));
                    continue;
                }
                buffer.append(ch);
            }
            this.description = buffer.toString();
            for (Map.Entry<String, String> acronym : acronyms) {
                this.description = this.description.replaceAll(acronym.getValue().toLowerCase(), acronym.getKey());
                this.description = this.description.replaceAll(acronym.getValue(), acronym.getKey());
            }
            this.description = this.description.trim();
        }
    }

    static {
        HashMap<String, String> acronymsMap = new HashMap<String, String>();
        acronymsMap.put("JDBC", "Jdbc");
        acronymsMap.put("ANSI", "Ansi");
        acronymsMap.put("SQL", "Sql");
        acronymsMap.put("URL", "Url");
        acronymsMap.put("TYPE_FORWARD_ONLY", "Type_forward_only");
        acronymsMap.put("TYPE_SCROLL_INSENSITIVE", "Type_scroll_insensitive");
        acronymsMap.put("TYPE_SCROLL_SENSITIVE", "Type_scroll_sensitive");
        acronyms = Collections.unmodifiableSet(acronymsMap.entrySet());
    }
}

