/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.NamedObjectSort;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureColumn;
import schemacrawler.schema.ProcedureType;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.Schema;

final class MutableProcedure
extends AbstractDatabaseObject
implements Procedure {
    private static final long serialVersionUID = 3906925686089134130L;
    private ProcedureType procedureType;
    private final NamedObjectList<MutableProcedureColumn> columns = new NamedObjectList();
    private RoutineBodyType routineBodyType;
    private final StringBuilder definition;

    MutableProcedure(Schema schema, String name) {
        super(schema, name);
        this.procedureType = ProcedureType.unknown;
        this.routineBodyType = RoutineBodyType.unknown;
        this.definition = new StringBuilder();
    }

    public MutableProcedureColumn getColumn(String name) {
        return this.columns.lookup(this, name);
    }

    public ProcedureColumn[] getColumns() {
        return this.columns.values().toArray(new ProcedureColumn[this.columns.size()]);
    }

    public String getDefinition() {
        return this.definition.toString();
    }

    public RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    public ProcedureType getType() {
        return this.procedureType;
    }

    void addColumn(MutableProcedureColumn column) {
        this.columns.add(column);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setColumnComparator(NamedObjectSort comparator) {
        this.columns.setSortOrder(comparator);
    }

    void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    void setType(ProcedureType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null procedure type");
        }
        this.procedureType = type;
    }
}

