/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProcedureType {
    unknown(0, "result unknown"),
    noResult(1, "no result"),
    returnsResult(2, "returns result");

    private static final Logger LOGGER;
    private final int id;
    private final String text;

    public static ProcedureType valueOf(int id) {
        for (ProcedureType type : ProcedureType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        LOGGER.log(Level.FINE, "Unknown id " + id);
        return unknown;
    }

    private ProcedureType(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.text;
    }

    static {
        LOGGER = Logger.getLogger(ProcedureType.class.getName());
    }
}

