/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnMap;
import schemacrawler.schema.Database;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaCrawlerInfo;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.Lint;
import schemacrawler.tools.analysis.Linter;
import schemacrawler.tools.analysis.LinterTableWithIncrementingColumns;
import schemacrawler.tools.analysis.LinterTableWithNoIndices;
import schemacrawler.tools.analysis.LinterTableWithNullColumnsInIndex;
import schemacrawler.tools.analysis.LinterTableWithNullIntendedColumns;
import schemacrawler.tools.analysis.LinterTableWithQuotedNames;
import schemacrawler.tools.analysis.LinterTableWithSingleColumn;
import schemacrawler.tools.analysis.WeakAssociationsAnalyzer;
import schemacrawler.tools.commandline.InfoLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalyzedDatabase
implements Database {
    private static final long serialVersionUID = -3953296149824921463L;
    private final Database database;
    private final List<Linter<Table>> tableLinters;

    public static final Lint[] getLint(Table table) {
        if (table == null) {
            return null;
        }
        List lintList = table.getAttribute("schemacrawler.lint", new ArrayList());
        Object[] lintArray = lintList.toArray(new Lint[lintList.size()]);
        Arrays.sort(lintArray);
        return lintArray;
    }

    public static final ColumnMap[] getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        return table.getAttribute("weak associations", new ColumnMap[0]);
    }

    public AnalyzedDatabase(Database database, InfoLevel infoLevel) {
        if (database == null) {
            throw new IllegalArgumentException("No database provided");
        }
        this.database = database;
        this.tableLinters = new ArrayList<Linter>(Arrays.asList(new LinterTableWithIncrementingColumns(), new LinterTableWithNoIndices(), new LinterTableWithNullColumnsInIndex(), new LinterTableWithNullIntendedColumns(), new LinterTableWithSingleColumn(), new LinterTableWithQuotedNames()));
        this.analyzeTables(infoLevel);
    }

    @Override
    public int compareTo(NamedObject o) {
        return this.database.compareTo(o);
    }

    @Override
    public Object getAttribute(String name) {
        return this.database.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        return this.database.getAttribute(name, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.database.getAttributes();
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.database.getDatabaseInfo();
    }

    @Override
    public String getFullName() {
        return this.database.getFullName();
    }

    @Override
    public JdbcDriverInfo getJdbcDriverInfo() {
        return this.database.getJdbcDriverInfo();
    }

    @Override
    public String getName() {
        return this.database.getName();
    }

    @Override
    public String getRemarks() {
        return this.database.getRemarks();
    }

    @Override
    public Schema getSchema(String name) {
        return this.database.getSchema(name);
    }

    @Override
    public SchemaCrawlerInfo getSchemaCrawlerInfo() {
        return this.database.getSchemaCrawlerInfo();
    }

    @Override
    public Schema[] getSchemas() {
        return this.database.getSchemas();
    }

    @Override
    public ColumnDataType getSystemColumnDataType(String name) {
        return this.database.getSystemColumnDataType(name);
    }

    @Override
    public ColumnDataType[] getSystemColumnDataTypes() {
        return this.database.getSystemColumnDataTypes();
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.database.setAttribute(name, value);
    }

    private void analyzeTables(InfoLevel infoLevel) {
        ArrayList<Table> allTables = new ArrayList<Table>();
        for (Schema schema : this.database.getSchemas()) {
            for (Table table : schema.getTables()) {
                allTables.add(table);
                if (infoLevel.ordinal() < InfoLevel.lint.ordinal()) continue;
                for (Linter<Table> tableLinter : this.tableLinters) {
                    tableLinter.lint(table);
                }
            }
        }
        if (infoLevel.ordinal() >= InfoLevel.maximum.ordinal()) {
            WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables);
            weakAssociationsAnalyzer.analyzeTables();
        }
    }
}

