/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTableWithNullColumnsInIndex
extends BaseLinter<Table> {
    @Override
    public void lint(Table table) {
        Index[] nullableColumnsInUniqueIndex;
        if (table != null && (nullableColumnsInUniqueIndex = this.findNullableColumnsInUniqueIndex(table.getIndices())).length > 0) {
            this.addLint(table, new Lint("unique indices with nullable columns", (Serializable)nullableColumnsInUniqueIndex){
                private static final long serialVersionUID = -1954217739621236510L;

                public String getLintValueAsString() {
                    ArrayList<String> indexNames = new ArrayList<String>();
                    for (Index index : nullableColumnsInUniqueIndex) {
                        indexNames.add(index.getName());
                    }
                    return ObjectToString.toString(indexNames);
                }
            });
        }
    }

    private Index[] findNullableColumnsInUniqueIndex(Index[] indices) {
        ArrayList<Index> nullableColumnsInUniqueIndex = new ArrayList<Index>();
        block0: for (Index index : indices) {
            IndexColumn[] columns;
            if (!index.isUnique()) continue;
            for (IndexColumn indexColumn : columns = index.getColumns()) {
                if (!indexColumn.isNullable()) continue;
                nullableColumnsInUniqueIndex.add(index);
                continue block0;
            }
        }
        return nullableColumnsInUniqueIndex.toArray(new Index[nullableColumnsInUniqueIndex.size()]);
    }
}

