/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.tools.analysis.BaseLinter;
import schemacrawler.tools.analysis.Lint;
import sf.util.ObjectToString;
import sf.util.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinterTableWithNullIntendedColumns
extends BaseLinter<Table> {
    @Override
    public void lint(Table table) {
        Column[] nullDefaultValueMayBeIntendedColumns;
        if (table != null && (nullDefaultValueMayBeIntendedColumns = this.findNullDefaultValueMayBeIntendedColumns(table.getColumns())).length > 0) {
            this.addLint(table, new Lint("columns where NULL may be intended", (Serializable)nullDefaultValueMayBeIntendedColumns){
                private static final long serialVersionUID = 4306137113072609086L;

                public String getLintValueAsString() {
                    ArrayList<String> columnNames = new ArrayList<String>();
                    for (Column column : nullDefaultValueMayBeIntendedColumns) {
                        columnNames.add(column.getName());
                    }
                    return ObjectToString.toString(columnNames);
                }
            });
        }
    }

    private Column[] findNullDefaultValueMayBeIntendedColumns(Column[] columns) {
        ArrayList<Column> nullDefaultValueMayBeIntendedColumns = new ArrayList<Column>();
        for (Column column : columns) {
            String columnDefaultValue = column.getDefaultValue();
            if (Utility.isBlank(columnDefaultValue) || !columnDefaultValue.trim().equalsIgnoreCase("NULL")) continue;
            nullDefaultValueMayBeIntendedColumns.add(column);
        }
        return nullDefaultValueMayBeIntendedColumns.toArray(new Column[nullDefaultValueMayBeIntendedColumns.size()]);
    }
}

