/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.commandline.ApplicationOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerCommandLine;
import schemacrawler.tools.commandline.SchemaCrawlerHelpCommandLine;
import schemacrawler.tools.options.ApplicationOptions;
import schemacrawler.tools.options.HelpOptions;

public class SchemaCrawlerMain {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerMain.class.getName());

    public static void main(String[] args) throws Exception {
        SchemaCrawlerMain.main(args, new HelpOptions(""), null);
    }

    public static void main(String[] args, HelpOptions helpOptions, String configResource) throws Exception {
        boolean showHelp;
        ApplicationOptions applicationOptions;
        if (args.length == 0) {
            applicationOptions = new ApplicationOptions();
            showHelp = true;
        } else {
            applicationOptions = new ApplicationOptionsParser(args).getOptions();
            showHelp = applicationOptions.isShowHelp();
        }
        applicationOptions.applyApplicationLogLevel();
        LOGGER.log(Level.CONFIG, "Command line: " + Arrays.toString(args));
        CommandLine commandLine = showHelp ? new SchemaCrawlerHelpCommandLine(args, helpOptions, configResource) : new SchemaCrawlerCommandLine(configResource, args);
        commandLine.execute();
    }

    private SchemaCrawlerMain() {
    }
}

