/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.Database;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import schemacrawler.tools.executable.Executable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.ObjectToString;

public abstract class BaseExecutable
implements Executable {
    private static final long serialVersionUID = -7346631903113057945L;
    private static final Logger LOGGER = Logger.getLogger(BaseExecutable.class.getName());
    protected final String command;
    protected SchemaCrawlerOptions schemaCrawlerOptions;
    protected OutputOptions outputOptions;
    protected Config additionalConfiguration;

    protected BaseExecutable(String command) {
        this.command = command;
        this.schemaCrawlerOptions = new SchemaCrawlerOptions();
        this.outputOptions = new OutputOptions();
    }

    public final void execute(Connection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException("No connection provided");
        }
        this.adjustSchemaInfoLevel();
        SchemaCrawler crawler = new SchemaCrawler(connection);
        Database database = crawler.crawl(this.schemaCrawlerOptions);
        this.executeOn(database, connection);
    }

    public final Config getAdditionalConfiguration() {
        return this.additionalConfiguration;
    }

    public final String getCommand() {
        return this.command;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }

    public final void setAdditionalConfiguration(Config additionalConfiguration) {
        this.additionalConfiguration = additionalConfiguration == null ? new Config() : additionalConfiguration;
    }

    public final void setOutputOptions(OutputOptions outputOptions) {
        this.outputOptions = outputOptions;
    }

    public final void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions;
    }

    public final String toString() {
        return ObjectToString.toString(this);
    }

    protected abstract void executeOn(Database var1, Connection var2) throws Exception;

    private void adjustSchemaInfoLevel() {
        SchemaInfoLevel infoLevel = this.schemaCrawlerOptions.getSchemaInfoLevel();
        if (!this.schemaCrawlerOptions.isAlphabeticalSortForTables() && !infoLevel.isRetrieveForeignKeys()) {
            infoLevel.setRetrieveTableColumns(true);
            infoLevel.setRetrieveForeignKeys(true);
            LOGGER.log(Level.WARNING, "Adjusted schema info level to retrieve foreign-keys, so tables can be sorted using the natural sort order");
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.log(Level.CONFIG, this.toString());
        }
    }
}

