/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.util;

import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.text.util.BaseTextFormattingHelper;
import schemacrawler.tools.text.util.TextFormattingHelper;
import sf.util.Utility;

public class PlainTextFormattingHelper
extends BaseTextFormattingHelper {
    public PlainTextFormattingHelper(OutputFormat outputFormat) {
        super(outputFormat);
    }

    public String createArrow() {
        return " --> ";
    }

    public String createDocumentEnd() {
        return "";
    }

    public String createDocumentStart() {
        return "";
    }

    public String createHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank(header)) {
            String separator;
            String prefix;
            String defaultSeparator = PlainTextFormattingHelper.separator("=");
            if (type == null) {
                prefix = Utility.NEWLINE;
                separator = defaultSeparator;
            } else {
                switch (type) {
                    case title: {
                        prefix = Utility.NEWLINE;
                        separator = PlainTextFormattingHelper.separator("_");
                        break;
                    }
                    case subTitle: {
                        prefix = Utility.NEWLINE;
                        separator = defaultSeparator;
                        break;
                    }
                    case section: {
                        prefix = "";
                        separator = PlainTextFormattingHelper.separator("-=-");
                        break;
                    }
                    default: {
                        prefix = Utility.NEWLINE;
                        separator = defaultSeparator;
                    }
                }
            }
            return Utility.NEWLINE + prefix + header + Utility.NEWLINE + separator + Utility.NEWLINE + prefix;
        }
        return "";
    }

    public String createObjectEnd() {
        return Utility.NEWLINE;
    }

    public String createObjectStart(String name) {
        String objectStart = "";
        if (!Utility.isBlank(name)) {
            objectStart = objectStart + Utility.NEWLINE + name + Utility.NEWLINE + DASHED_SEPARATOR;
        }
        return objectStart;
    }

    public String createPreformattedText(String id, String text) {
        return Utility.NEWLINE + text;
    }
}

