/*
 * Decompiled with CFR 0.152.
 */
package org.spin.identity.local;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.spin.identity.IdentityService;
import org.spin.identity.IdentityServiceException;
import org.spin.identity.local.LocalAuthEntry;
import org.spin.tools.Util;
import org.spin.tools.config.ConfigException;
import org.spin.tools.crypto.XMLSignatureUtil;
import org.spin.tools.crypto.signature.Identity;

public class LocalIdentityService
implements IdentityService {
    private static final Logger log = Logger.getLogger(LocalIdentityService.class);
    private static final boolean DEBUG = log.isInfoEnabled();
    private final Map<String, LocalAuthEntry> userDB = Util.makeHashMap();
    private final XMLSignatureUtil xmlSignatureUtil;

    public LocalIdentityService() {
        this(Collections.emptyList());
    }

    public LocalIdentityService(Collection<LocalAuthEntry> users) {
        try {
            this.xmlSignatureUtil = XMLSignatureUtil.getDefaultInstance();
        }
        catch (ConfigException e) {
            throw new IdentityServiceException("Error getting an XMLSignatureUtil instance: ", e);
        }
        for (LocalAuthEntry entry : users) {
            this.userDB.put(LocalIdentityService.getQualifiedUsername(entry), entry);
        }
    }

    @Override
    public Identity certify(String domain, String username, String password) {
        String qualifiedUsername = LocalIdentityService.getQualifiedUsername(domain, username);
        boolean userExists = this.userDB.containsKey(qualifiedUsername);
        if (DEBUG) {
            log.debug((Object)("Looking up domain:user " + qualifiedUsername + ", in the database? " + userExists));
        }
        if (!userExists || !this.userDB.get(qualifiedUsername).hasPassword(password)) {
            log.warn((Object)("Password failed for user " + username + " in domain " + domain));
            return new Identity();
        }
        Identity unsigned = new Identity(domain, username, this.userDB.get(qualifiedUsername).getAssertions());
        try {
            return this.xmlSignatureUtil.sign(unsigned);
        }
        catch (XMLSignatureException e) {
            throw new IdentityServiceException("Failed to sign identity", e);
        }
    }

    private static final String getQualifiedUsername(LocalAuthEntry authentry) {
        return LocalIdentityService.getQualifiedUsername(authentry.getDomain(), authentry.getUsername());
    }

    private static final String getQualifiedUsername(String domain, String username) {
        return domain.toLowerCase() + ":" + username.toLowerCase();
    }

    public static final Identity getUnsignedPublicIdentity() {
        return new Identity("public-domain", "public-user", "public-assertion");
    }
}

