/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.common.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ORIGINAL_OUTPUT_STREAM_KEY = GZIPOutInterceptor.class.getName() + ".originalOutputStream";
    public static final String USE_GZIP_KEY = GZIPOutInterceptor.class.getName() + ".useGzip";
    public static final String GZIP_ENCODING_KEY = GZIPOutInterceptor.class.getName() + ".gzipEncoding";
    public static final String SOAP_JMS_CONTENTENCODING = "SOAPJMS_contentEncoding";
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(GZIPOutInterceptor.class);
    private static final Logger LOG = LogUtils.getL7dLogger(GZIPOutInterceptor.class);
    private int threshold = 1024;

    public GZIPOutInterceptor() {
        super("prepare-send");
        this.addAfter(MessageSenderInterceptor.class.getName());
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void handleMessage(Message message) throws Fault {
        UseGzip use = this.gzipPermitted(message);
        if (use != UseGzip.NO) {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            if (os == null) {
                return;
            }
            message.put((Object)ORIGINAL_OUTPUT_STREAM_KEY, (Object)os);
            message.put((Object)USE_GZIP_KEY, (Object)use);
            GZipThresholdOutputStream cs = new GZipThresholdOutputStream(this.threshold, os, use == UseGzip.FORCE, message);
            message.setContent(OutputStream.class, (Object)cs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private UseGzip gzipPermitted(Message message) throws Fault {
        UseGzip permitted = UseGzip.NO;
        if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"))) {
            LOG.fine("Requestor role, so gzip enabled");
            permitted = UseGzip.YES;
            message.put((Object)GZIP_ENCODING_KEY, (Object)"gzip");
            GZIPOutInterceptor.addHeader(message, "Accept-Encoding", "gzip;q=1.0, identity; q=0.5, *;q=0");
        } else {
            LOG.fine("Response role, checking accept-encoding");
            Exchange exchange = message.getExchange();
            Message request = exchange.getInMessage();
            Map requestHeaders = CastUtils.cast((Map)((Map)request.get((Object)Message.PROTOCOL_HEADERS)));
            if (requestHeaders != null) {
                List acceptEncodingHeader = CastUtils.cast((List)HttpHeaderHelper.getHeader((Map)requestHeaders, (String)"Accept-Encoding"));
                List jmsEncodingHeader = CastUtils.cast((List)((List)requestHeaders.get(SOAP_JMS_CONTENTENCODING)));
                if (jmsEncodingHeader != null && jmsEncodingHeader.contains("gzip")) {
                    permitted = UseGzip.YES;
                    message.put((Object)GZIP_ENCODING_KEY, (Object)"gzip");
                }
                if (acceptEncodingHeader != null) {
                    boolean xGzipEnabled;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Accept-Encoding header: " + acceptEncodingHeader);
                    }
                    ArrayList<String> zeros = new ArrayList<String>(3);
                    ArrayList<String> nonZeros = new ArrayList<String>(3);
                    Pattern zeroQ = Pattern.compile(";\\s*q=0(?:\\.0+)?$");
                    for (String headerLine : acceptEncodingHeader) {
                        String[] encodings;
                        for (String enc : encodings = headerLine.trim().split("[,\\s]*,\\s*")) {
                            Matcher m = zeroQ.matcher(enc);
                            if (m.find()) {
                                zeros.add(enc.substring(0, m.start()));
                                continue;
                            }
                            if (enc.indexOf(59) >= 0) {
                                nonZeros.add(enc.substring(0, enc.indexOf(59)));
                                continue;
                            }
                            nonZeros.add(enc);
                        }
                    }
                    boolean identityEnabled = !zeros.contains("identity") && (!zeros.contains("*") || nonZeros.contains("identity"));
                    boolean gzipEnabled = nonZeros.contains("gzip") || nonZeros.contains("*") && !zeros.contains("gzip");
                    boolean bl = xGzipEnabled = nonZeros.contains("x-gzip") || nonZeros.contains("*") && !zeros.contains("x-gzip");
                    if (identityEnabled && !gzipEnabled && !xGzipEnabled) {
                        permitted = UseGzip.NO;
                    } else if (identityEnabled && gzipEnabled) {
                        permitted = UseGzip.YES;
                        message.put((Object)GZIP_ENCODING_KEY, (Object)"gzip");
                    } else if (identityEnabled && xGzipEnabled) {
                        permitted = UseGzip.YES;
                        message.put((Object)GZIP_ENCODING_KEY, (Object)"x-gzip");
                    } else if (!identityEnabled && gzipEnabled) {
                        permitted = UseGzip.FORCE;
                        message.put((Object)GZIP_ENCODING_KEY, (Object)"gzip");
                    } else {
                        if (identityEnabled || !xGzipEnabled) throw new Fault(new org.apache.cxf.common.i18n.Message("NO_SUPPORTED_ENCODING", BUNDLE, new Object[0]));
                        permitted = UseGzip.FORCE;
                        message.put((Object)GZIP_ENCODING_KEY, (Object)"x-gzip");
                    }
                } else {
                    LOG.fine("No accept-encoding header");
                }
            }
        }
        if (!LOG.isLoggable(Level.FINE)) return permitted;
        LOG.fine("gzip permitted: " + (Object)((Object)permitted));
        return permitted;
    }

    private static void addHeader(Message message, String name, String value) {
        ArrayList<String> header;
        TreeMap protocolHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (protocolHeaders == null) {
            protocolHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put((Object)Message.PROTOCOL_HEADERS, protocolHeaders);
        }
        if ((header = CastUtils.cast((List)((List)protocolHeaders.get(name)))) == null) {
            header = new ArrayList<String>();
            protocolHeaders.put(name, header);
        }
        if (header.size() == 0) {
            header.add(value);
        } else {
            header.set(0, (String)header.get(0) + "," + value);
        }
    }

    static class GZipThresholdOutputStream
    extends AbstractThresholdOutputStream {
        Message message;

        public GZipThresholdOutputStream(int t, OutputStream orig, boolean force, Message msg) {
            super(t);
            this.wrappedStream = orig;
            this.message = msg;
            if (force) {
                this.setupGZip();
            }
        }

        private void setupGZip() {
        }

        public void thresholdNotReached() {
            LOG.fine("Message is smaller than compression threshold, not compressing.");
        }

        public void thresholdReached() throws IOException {
            LOG.fine("Compressing message.");
            String enc = (String)this.message.get((Object)GZIP_ENCODING_KEY);
            GZIPOutInterceptor.addHeader(this.message, "Content-Encoding", enc);
            if (!Boolean.TRUE.equals(this.message.get((Object)"org.apache.cxf.client"))) {
                GZIPOutInterceptor.addHeader(this.message, "Vary", "Accept-Encoding");
            }
            GZIPOutputStream zipOutput = new GZIPOutputStream(this.wrappedStream);
            this.wrappedStream = zipOutput;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UseGzip {
        NO,
        YES,
        FORCE;

    }
}

