/*
 * Decompiled with CFR 0.152.
 */
package org.spin.tools;

import java.util.Iterator;
import org.spin.tools.Util;

public final class ConcatenatedIterator<T>
implements Iterator<T> {
    private final Iterator<? extends T> leftDelegate;
    private final Iterator<? extends T> rightDelegate;

    public static <T> ConcatenatedIterator<T> from(Iterator<? extends T> leftDelegate, Iterator<? extends T> rightDelegate) {
        return new ConcatenatedIterator<T>(leftDelegate, rightDelegate);
    }

    public static <T> ConcatenatedIterator<T> from(Iterable<? extends T> leftDelegate, Iterable<? extends T> rightDelegate) {
        return new ConcatenatedIterator<T>(leftDelegate.iterator(), rightDelegate.iterator());
    }

    public ConcatenatedIterator(Iterator<? extends T> leftDelegate, Iterator<? extends T> rightDelegate) {
        Util.guardNotNull(leftDelegate);
        Util.guardNotNull(rightDelegate);
        this.leftDelegate = leftDelegate;
        this.rightDelegate = rightDelegate;
    }

    @Override
    public boolean hasNext() {
        return this.leftDelegate.hasNext() || this.rightDelegate.hasNext();
    }

    @Override
    public T next() {
        Util.require(this.leftDelegate.hasNext() || this.rightDelegate.hasNext());
        if (this.leftDelegate.hasNext()) {
            return this.leftDelegate.next();
        }
        return this.rightDelegate.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

